/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.config;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.util.Configuration;

public class HierarchicalConfiguration
implements ModifiableConfiguration {
    private Properties configuration = new Properties();
    private transient Configuration parentConfiguration;

    public HierarchicalConfiguration() {
    }

    public HierarchicalConfiguration(Configuration configuration) {
        this();
        this.parentConfiguration = configuration;
    }

    private void collectPropertyKeys(String string, Configuration configuration, TreeSet treeSet) {
        Object object;
        Enumeration enumeration = configuration.getConfigProperties();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith(string) || treeSet.contains(object)) continue;
            treeSet.add(object);
        }
        if (configuration instanceof HierarchicalConfiguration) {
            object = (HierarchicalConfiguration)configuration;
            if (((HierarchicalConfiguration)object).parentConfiguration != null) {
                this.collectPropertyKeys(string, ((HierarchicalConfiguration)object).parentConfiguration, treeSet);
            }
        }
    }

    protected final void configurationLoaded() {
    }

    public Iterator findPropertyKeys(String string) {
        TreeSet treeSet = new TreeSet();
        this.collectPropertyKeys(string, this, treeSet);
        return Collections.unmodifiableSet(treeSet).iterator();
    }

    public Enumeration getConfigProperties() {
        return ((Hashtable)this.configuration).keys();
    }

    public String getConfigProperty(String string) {
        return this.getConfigProperty(string, null);
    }

    public String getConfigProperty(String string, String string2) {
        String string3 = this.configuration.getProperty(string);
        if (string3 == null) {
            string3 = this.isRootConfig() ? string2 : this.parentConfiguration.getConfigProperty(string, string2);
        }
        return string3;
    }

    protected final Properties getConfiguration() {
        return this.configuration;
    }

    protected final Configuration getParentConfig() {
        return this.parentConfiguration;
    }

    public void insertConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        hierarchicalConfiguration.setParentConfig(this.getParentConfig());
        this.setParentConfig(hierarchicalConfiguration);
    }

    public boolean isLocallyDefined(String string) {
        return ((Hashtable)this.configuration).containsKey(string);
    }

    protected final boolean isParentSaved() {
        return true;
    }

    private boolean isRootConfig() {
        return this.parentConfiguration == null;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        this.parentConfiguration = bl ? (ModifiableConfiguration)objectInputStream.readObject() : null;
        this.configurationLoaded();
    }

    public void setConfigProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            ((Hashtable)this.configuration).remove(string);
        } else {
            this.configuration.setProperty(string, string2);
        }
    }

    protected final void setParentConfig(Configuration configuration) {
        if (this.parentConfiguration == this) {
            throw new IllegalArgumentException("Cannot add myself as parent configuration.");
        }
        this.parentConfiguration = configuration;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        if (!this.isParentSaved()) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.parentConfiguration);
        }
    }
}

