/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import org.jaxen.Context;
import org.jaxen.pattern.Pattern;

public class UnionPattern
extends Pattern {
    private Pattern lhs;
    private Pattern rhs;
    private short nodeType = 0;
    private String matchesNodeName = null;

    public UnionPattern() {
    }

    public UnionPattern(Pattern pattern, Pattern pattern2) {
        this.lhs = pattern;
        this.rhs = pattern2;
        this.init();
    }

    public final Pattern getLHS() {
        return this.lhs;
    }

    public final short getMatchType() {
        return this.nodeType;
    }

    public final String getMatchesNodeName() {
        return this.matchesNodeName;
    }

    public final Pattern getRHS() {
        return this.rhs;
    }

    public final String getText() {
        return String.valueOf(this.lhs.getText()) + " | " + this.rhs.getText();
    }

    public final Pattern[] getUnionPatterns() {
        return new Pattern[]{this.lhs, this.rhs};
    }

    private void init() {
        short s;
        short s2 = this.lhs.getMatchType();
        this.nodeType = s2 == (s = this.rhs.getMatchType()) ? s2 : (short)0;
        String string = this.lhs.getMatchesNodeName();
        String string2 = this.rhs.getMatchesNodeName();
        this.matchesNodeName = null;
        if (string != null && string2 != null && string.equals(string2)) {
            this.matchesNodeName = string;
        }
    }

    public final boolean matches(Object object, Context context) {
        return this.lhs.matches(object, context) || this.rhs.matches(object, context);
    }

    public final void setLHS(Pattern pattern) {
        this.lhs = pattern;
        this.init();
    }

    public final void setRHS(Pattern pattern) {
        this.rhs = pattern;
        this.init();
    }

    public final Pattern simplify() {
        this.lhs = this.lhs.simplify();
        this.rhs = this.rhs.simplify();
        this.init();
        return this;
    }

    public final String toString() {
        return String.valueOf(super.toString()) + "[ lhs: " + this.lhs + " rhs: " + this.rhs + " ]";
    }
}

