/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class NumberFunction
implements Function {
    private static final Double NaN = new Double(Double.NaN);

    public final Object call(Context context, List list) {
        if (list.size() == 1) {
            return NumberFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("number() requires one argument.");
    }

    public static final Double evaluate(Object object, Navigator navigator) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return new Double(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            if (object == Boolean.TRUE) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                Double d2 = new Double(string);
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(Double.NaN);
            }
        }
        if (object instanceof List || object instanceof Iterator) {
            String string = StringFunction.evaluate(object, navigator);
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        if (navigator.isElement(object) || navigator.isAttribute(object)) {
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        return new Double(Double.NaN);
    }

    public static final boolean isNaN(double d2) {
        return NumberFunction.isNaN(new Double(d2));
    }

    public static final boolean isNaN(Double d2) {
        return d2.equals(NaN);
    }
}

