/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.util.Iterator;
import java.util.LinkedList;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Predicated;
import org.jaxen.expr.Step;
import org.jaxen.expr.XPathExpr;
import org.jaxen.expr.XPathFactory;
import org.saxpath.XPathHandler;

public class JaxenHandler
implements XPathHandler {
    private XPathFactory xpathFactory;
    private XPathExpr xpath;
    protected boolean simplified;
    protected LinkedList stack = new LinkedList();

    public JaxenHandler() {
        this.xpathFactory = new DefaultXPathFactory();
    }

    protected final void addParameters(FunctionCallExpr functionCallExpr, Iterator iterator) {
        while (iterator.hasNext()) {
            functionCallExpr.addParameter((Expr)iterator.next());
        }
    }

    protected final void addPredicates(Predicated predicated, Iterator iterator) {
        while (iterator.hasNext()) {
            predicated.addPredicate((Predicate)iterator.next());
        }
    }

    protected final void addSteps(LocationPath locationPath, Iterator iterator) {
        while (iterator.hasNext()) {
            locationPath.addStep((Step)iterator.next());
        }
    }

    protected final boolean canPop() {
        return this.peekFrame().size() > 0;
    }

    public final void endAbsoluteLocationPath() {
        this.endLocationPath();
    }

    public final void endAdditiveExpr(int n) {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createAdditiveExpr(expr2, expr, n));
        }
    }

    public final void endAllNodeStep() {
        this.endStep();
    }

    public final void endAndExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createAndExpr(expr2, expr));
        }
    }

    public final void endCommentNodeStep() {
        this.endStep();
    }

    public final void endEqualityExpr(int n) {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createEqualityExpr(expr2, expr, n));
        }
    }

    public final void endFilterExpr() {
        Expr expr = (Expr)this.peekFrame().removeFirst();
        FilterExpr filterExpr = this.getXPathFactory().createFilterExpr(expr);
        Iterator iterator = this.popFrame().iterator();
        this.addPredicates(filterExpr, iterator);
        this.push(filterExpr);
    }

    public final void endFunction() {
        FunctionCallExpr functionCallExpr = (FunctionCallExpr)this.peekFrame().removeFirst();
        this.addParameters(functionCallExpr, this.popFrame().iterator());
        this.push(functionCallExpr);
    }

    protected final void endLocationPath() {
        LocationPath locationPath = (LocationPath)this.peekFrame().removeFirst();
        this.addSteps(locationPath, this.popFrame().iterator());
        this.push(locationPath);
    }

    public final void endMultiplicativeExpr(int n) {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createMultiplicativeExpr(expr2, expr, n));
        }
    }

    public final void endNameStep() {
        this.endStep();
    }

    public final void endOrExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createOrExpr(expr2, expr));
        }
    }

    public final void endPathExpr() {
        FilterExpr filterExpr;
        LocationPath locationPath;
        if (this.stackSize() == 2) {
            locationPath = (LocationPath)this.pop();
            filterExpr = (FilterExpr)this.pop();
        } else {
            Object object = this.pop();
            if (object instanceof LocationPath) {
                locationPath = (LocationPath)object;
                filterExpr = null;
            } else {
                locationPath = null;
                filterExpr = (FilterExpr)object;
            }
        }
        this.popFrame();
        this.push(this.getXPathFactory().createPathExpr(filterExpr, locationPath));
    }

    public final void endPredicate() {
        Predicate predicate = this.getXPathFactory().createPredicate((Expr)this.pop());
        this.popFrame();
        this.push(predicate);
    }

    public final void endProcessingInstructionNodeStep() {
        this.endStep();
    }

    public final void endRelationalExpr(int n) {
        if (n != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createRelationalExpr(expr2, expr, n));
        }
    }

    public final void endRelativeLocationPath() {
        this.endLocationPath();
    }

    protected final void endStep() {
        Step step = (Step)this.peekFrame().removeFirst();
        this.addPredicates(step, this.popFrame().iterator());
        this.push(step);
    }

    public final void endTextNodeStep() {
        this.endStep();
    }

    public final void endUnaryExpr(int n) {
        if (n != 0) {
            this.push(this.getXPathFactory().createUnaryExpr((Expr)this.pop(), n));
        }
    }

    public final void endUnionExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            this.push(this.getXPathFactory().createUnionExpr(expr2, expr));
        }
    }

    public final void endXPath() {
        this.xpath = this.getXPathFactory().createXPath((Expr)this.pop());
        this.popFrame();
    }

    public final XPathExpr getXPathExpr() {
        return this.getXPathExpr(true);
    }

    public final XPathExpr getXPathExpr(boolean bl) {
        if (bl && !this.simplified) {
            this.xpath.simplify();
            this.simplified = true;
        }
        return this.xpath;
    }

    public final XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public final void literal(String string) {
        this.push(this.getXPathFactory().createLiteralExpr(string));
    }

    public final void number(double d2) {
        this.push(this.getXPathFactory().createNumberExpr(d2));
    }

    public final void number(int n) {
        this.push(this.getXPathFactory().createNumberExpr(n));
    }

    protected final LinkedList peekFrame() {
        return (LinkedList)this.stack.getLast();
    }

    protected final Object pop() {
        return this.peekFrame().removeLast();
    }

    protected final LinkedList popFrame() {
        return (LinkedList)this.stack.removeLast();
    }

    protected final void push(Object object) {
        this.peekFrame().addLast(object);
    }

    protected final void pushFrame() {
        this.stack.addLast(new LinkedList());
    }

    protected final void returnExpr() {
        Expr expr = (Expr)this.pop();
        this.popFrame();
        this.push(expr);
    }

    public final void setXPathFactory(XPathFactory xPathFactory) {
        this.xpathFactory = xPathFactory;
    }

    protected final int stackSize() {
        return this.peekFrame().size();
    }

    public final void startAbsoluteLocationPath() {
        this.pushFrame();
        this.push(this.getXPathFactory().createAbsoluteLocationPath());
    }

    public final void startAdditiveExpr() {
    }

    public final void startAllNodeStep(int n) {
        this.pushFrame();
        this.push(this.getXPathFactory().createAllNodeStep(n));
    }

    public final void startAndExpr() {
    }

    public final void startCommentNodeStep(int n) {
        this.pushFrame();
        this.push(this.getXPathFactory().createCommentNodeStep(n));
    }

    public final void startEqualityExpr() {
    }

    public final void startFilterExpr() {
        this.pushFrame();
    }

    public final void startFunction(String string, String string2) {
        this.pushFrame();
        this.push(this.getXPathFactory().createFunctionCallExpr(string, string2));
    }

    public final void startMultiplicativeExpr() {
    }

    public final void startNameStep(int n, String string, String string2) {
        this.pushFrame();
        this.push(this.getXPathFactory().createNameStep(n, string, string2));
    }

    public final void startOrExpr() {
    }

    public final void startPathExpr() {
        this.pushFrame();
    }

    public final void startPredicate() {
        this.pushFrame();
    }

    public final void startProcessingInstructionNodeStep(int n, String string) {
        this.pushFrame();
        this.push(this.getXPathFactory().createProcessingInstructionNodeStep(n, string));
    }

    public final void startRelationalExpr() {
    }

    public final void startRelativeLocationPath() {
        this.pushFrame();
        this.push(this.getXPathFactory().createRelativeLocationPath());
    }

    public final void startTextNodeStep(int n) {
        this.pushFrame();
        this.push(this.getXPathFactory().createTextNodeStep(n));
    }

    public final void startUnaryExpr() {
    }

    public final void startUnionExpr() {
    }

    public final void startXPath() {
        this.simplified = false;
        this.pushFrame();
    }

    public final void variableReference(String string, String string2) {
        this.push(this.getXPathFactory().createVariableReferenceExpr(string, string2));
    }
}

