/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.uiutil;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI2
extends BasicLabelUI {
    protected boolean clockwise;
    private static Rectangle paintIconR;
    private static Rectangle paintTextR;
    private static Rectangle paintViewR;
    private static Insets paintViewInsets;

    public VerticalLabelUI2(boolean bl) {
        this.clockwise = bl;
    }

    @Override
    public final void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBackground(UIManager.getDefaults().getColor("Table.background"));
    }

    @Override
    public final Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public final void paint(Graphics graphics, JComponent jComponent) {
        Icon icon;
        JLabel jLabel = (JLabel)jComponent;
        String string = jLabel.getText();
        Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        if (icon == null && string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        paintViewInsets = jComponent.getInsets(paintViewInsets);
        VerticalLabelUI2.paintViewR.x = VerticalLabelUI2.paintViewInsets.left;
        VerticalLabelUI2.paintViewR.y = VerticalLabelUI2.paintViewInsets.top;
        VerticalLabelUI2.paintViewR.height = jComponent.getWidth() - (VerticalLabelUI2.paintViewInsets.left + VerticalLabelUI2.paintViewInsets.right);
        VerticalLabelUI2.paintViewR.width = jComponent.getHeight() - (VerticalLabelUI2.paintViewInsets.top + VerticalLabelUI2.paintViewInsets.bottom);
        VerticalLabelUI2.paintIconR.height = 0;
        VerticalLabelUI2.paintIconR.width = 0;
        VerticalLabelUI2.paintIconR.y = 0;
        VerticalLabelUI2.paintIconR.x = 0;
        VerticalLabelUI2.paintTextR.height = 0;
        VerticalLabelUI2.paintTextR.width = 0;
        VerticalLabelUI2.paintTextR.y = 0;
        VerticalLabelUI2.paintTextR.x = 0;
        String string2 = this.layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.clockwise) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -jComponent.getWidth());
        } else {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-jComponent.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, VerticalLabelUI2.paintIconR.x, VerticalLabelUI2.paintIconR.y);
        }
        if (string != null) {
            int n = icon != null ? icon.getIconHeight() : 0;
            int n2 = VerticalLabelUI2.paintTextR.x + n;
            int n3 = VerticalLabelUI2.paintTextR.y + fontMetrics.getAscent();
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string2, n2, n3);
            } else {
                this.paintDisabledText(jLabel, graphics, string2, n2, n3);
            }
        }
        graphics2D.setTransform(affineTransform);
    }

    static {
        labelUI = new VerticalLabelUI2(false);
        paintIconR = new Rectangle();
        paintTextR = new Rectangle();
        paintViewR = new Rectangle();
        paintViewInsets = new Insets(0, 0, 0, 0);
    }
}

