/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.table;

import java.awt.Color;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.genepattern.table.GPTable$1;
import org.genepattern.table.GPTable$2;
import org.genepattern.table.GPTable$CopyAction;
import org.genepattern.table.GPTable$SelectAllAction;

public class GPTable
extends JTable {
    GPTable$CopyAction copy = new GPTable$CopyAction(this);
    GPTable$SelectAllAction selectAllAction = new GPTable$SelectAllAction(this);

    public GPTable(TableModel tableModel) {
        super(tableModel);
        this.setShowGrid(true);
        this.setGridColor(Color.black);
        this.setColumnSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setAutoResizeMode(4);
        this.addMouseListener(new GPTable$1(this));
    }

    @Override
    protected final JTableHeader createDefaultTableHeader() {
        return new GPTable$2(this, this.columnModel);
    }

    public final Action getCopyAction() {
        return this.copy;
    }

    public final Action getSelectAllAction() {
        return this.selectAllAction;
    }

    public final void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        StringBuffer stringBuffer = GPTable.getSelectedData(this, nArray, nArray2);
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static final StringBuffer getSelectedData(JTable jTable, int[] nArray, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                Object object = jTable.getValueAt(nArray[i2], nArray2[i3]);
                if (object != null) {
                    stringBuffer.append(object);
                }
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    @Override
    public final String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (object = this.getValueAt(n2, n)) != null) {
            string = object.toString();
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }
}

