/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.module;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.io.IOUtil;
import org.genepattern.io.IOdfHandler;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.ExpressionDataCreator;
import org.genepattern.io.expr.IExpressionDataCreator;
import org.genepattern.io.expr.IExpressionDataParser;
import org.genepattern.io.expr.ReaderUtil;
import org.genepattern.module.AnalysisUtil;

public class VisualizerUtil {
    private VisualizerUtil() {
    }

    public static final void centerOnScreen(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation((dimension.width - component.getWidth()) / 2, (dimension.height - component.getHeight()) / 2);
    }

    public static final void showFrame(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        window.setSize(dimension);
        window.setLocation((dimension.width - window.getWidth()) / 2, (dimension.height - window.getHeight()) / 2);
        window.setVisible(true);
    }

    public static final void error(Component component, String string, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 != null) {
            string = string + "\nCause: " + string2;
        }
        VisualizerUtil.error(component, string);
    }

    public static final void error(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "Error", 0);
    }

    public static final ClassVector readCls(Component component, String string) {
        try {
            return IOUtil.readCls(string);
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + new File(string).getName());
            return null;
        }
        catch (ParseException parseException) {
            VisualizerUtil.fileReadError(parseException, component, string);
            return null;
        }
    }

    public static final List readFeatureList(Component component, String string) {
        try {
            return IOUtil.readFeatureList(string);
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + new File(string).getName());
            return null;
        }
    }

    public static final Object readExpressionData(Component component, IExpressionDataParser iExpressionDataParser, String string, IExpressionDataCreator iExpressionDataCreator) {
        try {
            return ReaderUtil.read(iExpressionDataParser, string, iExpressionDataCreator);
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + new File(string).getName());
            return null;
        }
        catch (ParseException parseException) {
            VisualizerUtil.fileReadError(parseException, component, string);
            return null;
        }
    }

    public static final ExpressionData readExpressionData(Component component, IExpressionDataParser iExpressionDataParser, String string) {
        try {
            return (ExpressionData)ReaderUtil.read(iExpressionDataParser, string, (IExpressionDataCreator)new ExpressionDataCreator());
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + new File(string).getName());
            return null;
        }
        catch (ParseException parseException) {
            VisualizerUtil.fileReadError(parseException, component, string);
            return null;
        }
    }

    public static final ExpressionData readExpressionData(Component component, File file) {
        try {
            return IOUtil.readExpressionData(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + file.getName());
            return null;
        }
        catch (ParseException parseException) {
            VisualizerUtil.fileReadError(parseException, component, file.getName());
            return null;
        }
    }

    public static final ExpressionData getExpressionData(Component component, IExpressionDataParser iExpressionDataParser, String string) {
        try {
            return (ExpressionData)ReaderUtil.read(iExpressionDataParser, string, (IExpressionDataCreator)new ExpressionDataCreator());
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + new File(string).getName());
            return null;
        }
        catch (ParseException parseException) {
            VisualizerUtil.fileReadError(parseException, component, string);
            return null;
        }
    }

    public static final boolean readOdf(Component component, String string, IOdfHandler iOdfHandler) {
        try {
            IOUtil.readOdf(string, iOdfHandler);
            return true;
        }
        catch (IOException iOException) {
            VisualizerUtil.error(component, "An error occured while reading the file " + new File(string).getName());
            return false;
        }
        catch (ParseException parseException) {
            VisualizerUtil.fileReadError(parseException, component, string);
            return false;
        }
    }

    public static final String writeCls(Component component, ClassVector classVector, String string, boolean bl) {
        try {
            return IOUtil.writeCls(classVector, string, bl);
        }
        catch (Exception exception) {
            VisualizerUtil.fileSaveError(exception, component, string);
            return null;
        }
    }

    public static final String write(Component component, IExpressionData iExpressionData, String string, String string2, boolean bl) {
        try {
            return IOUtil.write(iExpressionData, string, string2, bl);
        }
        catch (IOException iOException) {
            VisualizerUtil.fileSaveError(iOException, component, string2);
            return null;
        }
    }

    private static void fileReadError(Exception exception, Component component, String string) {
        String string2 = "An error occured while reading the file " + AnalysisUtil.getFileName(string) + ".";
        String string3 = exception.getMessage();
        if (string3 != null) {
            string2 = string2 + "\nCause: " + string3;
        }
        VisualizerUtil.error(component, string2);
    }

    private static void fileSaveError(Exception exception, Component component, String string) {
        String string2 = "An error occured while attempting to save the file " + AnalysisUtil.getFileName(string) + ".";
        String string3 = exception.getMessage();
        if (string3 != null) {
            string2 = string2 + "\nCause: " + string3;
        }
        VisualizerUtil.error(component, string2);
    }

    public static final IExpressionDataParser getExpressionDataParser(Component component, String string) {
        try {
            IExpressionDataParser iExpressionDataParser = IOUtil.getExpressionParser(string);
            if (iExpressionDataParser == null) {
                VisualizerUtil.error(component, "Invalid input type: " + AnalysisUtil.getFileName(string) + " is not a res, gct, or odf dataset file.");
            }
            return iExpressionDataParser;
        }
        catch (Exception exception) {
            VisualizerUtil.fileReadError(exception, component, string);
            return null;
        }
    }

    public static final IExpressionDataParser getExpressionReader(Component component, String string) {
        return VisualizerUtil.getExpressionDataParser(component, string);
    }
}

