/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu.jfree;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.KeyStroke;
import org.genepattern.menu.PlotAction;
import org.genepattern.uiutil.UIUtil;
import org.jfree.chart.ChartPanel;

public class JFreePrintAction
extends PlotAction {
    public JFreePrintAction() {
        super("Print...");
        if (System.getProperty("org.genepattern.menu.showAccelerators", "true").equalsIgnoreCase("true")) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            this.putValue("AcceleratorKey", keyStroke);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        ChartPanel chartPanel = (ChartPanel)this.getPlot();
        printerJob.setPrintable(chartPanel);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                UIUtil.showErrorDialog(chartPanel.getTopLevelAncestor(), "A printing error occurred.");
            }
        }
    }
}

