/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu;

import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.genepattern.menu.EditMenu;
import org.genepattern.menu.FileMenu;
import org.genepattern.menu.ViewMenu;
import org.genepattern.table.GPTable;

public abstract class GPMenuBar
extends JMenuBar {
    protected FileMenu fileMenu;
    protected EditMenu editMenu;
    protected ViewMenu viewMenu;
    protected Frame parent;
    protected boolean showExitMenu = false;

    protected abstract FileMenu createFileMenu(JComponent var1);

    protected abstract ViewMenu createViewMenu(JComponent var1);

    public GPMenuBar(JComponent jComponent, Frame frame) {
        if (frame == null) {
            throw new NullPointerException("Null parent not allowed");
        }
        this.parent = frame;
        this.fileMenu = this.createFileMenu(jComponent);
        this.viewMenu = this.createViewMenu(jComponent);
        this.add(this.fileMenu);
        this.add(this.viewMenu);
    }

    public GPMenuBar(GPTable gPTable, JComponent jComponent, Frame frame, int n) {
        if (frame == null) {
            throw new NullPointerException("Null parent not allowed");
        }
        this.parent = frame;
        this.fileMenu = this.createFileMenu(jComponent);
        this.viewMenu = this.createViewMenu(jComponent);
        this.editMenu = new EditMenu(frame, gPTable, n);
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.viewMenu);
    }

    public GPMenuBar(GPTable gPTable, JComponent jComponent, Frame frame, int n, boolean bl) {
        if (frame == null) {
            throw new NullPointerException("Null parent not allowed");
        }
        this.parent = frame;
        this.showExitMenu = bl;
        this.fileMenu = this.createFileMenu(jComponent);
        this.editMenu = new EditMenu(frame, gPTable, n);
        this.viewMenu = this.createViewMenu(jComponent);
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.viewMenu);
    }

    public final void setPlot(JComponent jComponent) {
        this.viewMenu.setPlot(jComponent);
        this.fileMenu.setPlot(jComponent);
    }

    public final JMenu getFileMenu() {
        return this.fileMenu;
    }

    public final JMenu getEditMenu() {
        return this.editMenu;
    }

    public final JMenu getViewMenu() {
        return this.viewMenu;
    }
}

