/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.stanford;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.IExpressionDataHandler;

public class CdtParser {
    protected int rows;
    protected int columns;
    protected String[] columnNames;
    protected boolean name_col = false;
    protected boolean eweight = false;
    protected boolean eorder = false;
    protected boolean gweight = false;
    protected boolean gorder = false;
    protected String urlIdentifier;
    protected boolean aid = false;
    protected boolean gid_col = false;
    protected List rowNames = new ArrayList();
    protected List rowDescriptions = new ArrayList();
    protected List values = new ArrayList();
    protected List geneIds = new ArrayList();
    protected IExpressionDataHandler handler;
    private String[] arrayIds;

    public final List getGeneIds() {
        return this.geneIds;
    }

    public final String[] getArrayIds() {
        return this.arrayIds;
    }

    private final boolean hasColumnName() {
        return this.name_col;
    }

    private final boolean hasGid() {
        return this.gid_col;
    }

    private final boolean hasAid() {
        return this.aid;
    }

    private final boolean hasEweight() {
        return this.eweight;
    }

    private final boolean hasEorder() {
        return this.eorder;
    }

    private final boolean hasGweight() {
        return this.gweight;
    }

    private final boolean hasGorder() {
        return this.gorder;
    }

    public final void setHandler(IExpressionDataHandler iExpressionDataHandler) {
        this.handler = iExpressionDataHandler;
    }

    public final boolean canDecode(InputStream inputStream) {
        return false;
    }

    public final void parse(InputStream inputStream) {
        LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        this._parse(lineNumberReader);
    }

    public final ExpressionData getExpressionData() {
        Object[] objectArray;
        double[][] dArrayArray = new double[this.rows][];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            dArrayArray[i2] = objectArray = (double[])this.values.get(i2);
        }
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D(dArrayArray, this.rowNames.toArray(new String[0]), this.columnNames);
        objectArray = null;
        if (this.rowDescriptions != null && this.rowDescriptions.size() == this.rowNames.size()) {
            objectArray = this.rowDescriptions.toArray(new String[0]);
        }
        return new ExpressionData(doubleMatrix2D, (String[])objectArray, null);
    }

    protected final void _parse(LineNumberReader lineNumberReader) {
        String string = lineNumberReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("GID")) {
            this.gid_col = true;
            string2 = stringTokenizer.nextToken();
            this.urlIdentifier = stringTokenizer.nextToken();
        } else {
            this.urlIdentifier = string2;
        }
        string2 = stringTokenizer.nextToken();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("name")) {
                this.name_col = true;
                string2 = stringTokenizer.nextToken();
            } else if (string2.equalsIgnoreCase("gweight")) {
                this.gweight = true;
                string2 = stringTokenizer.nextToken();
            } else if (string2.equalsIgnoreCase("gorder")) {
                this.gorder = true;
                string2 = stringTokenizer.nextToken();
            } else {
                ++n;
            }
            if (string2.equals("\t") || !stringTokenizer.hasMoreTokens()) continue;
            string2 = stringTokenizer.nextToken();
        }
        this.columns = n;
        stringTokenizer = new StringTokenizer(string, "\t", true);
        if (this.hasGid()) {
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        if (this.hasColumnName()) {
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        if (this.hasGweight()) {
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        if (this.hasGorder()) {
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        this.columnNames = new String[this.columns];
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.equals("\t")) {
                this.columnNames[n] = string2;
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            }
            ++n;
        }
        if (n != this.columns) {
            throw new ParseException("Unexpected number of columns on line " + lineNumberReader.getLineNumber());
        }
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("AID")) {
                this.aid = true;
                this.setArrayIds(string);
                continue;
            }
            if (string.startsWith("EWEIGHT")) {
                this.eweight = true;
                continue;
            }
            if (string.startsWith("EORDER")) {
                this.eorder = true;
                continue;
            }
            this.parseLine(string);
            ++this.rows;
            while ((string = lineNumberReader.readLine()) != null) {
                this.parseLine(string);
                ++this.rows;
            }
        }
    }

    private void setArrayIds(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
        String string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        if (this.hasGid()) {
            string2 = stringTokenizer.nextToken();
        }
        if (this.name_col) {
            string2 = stringTokenizer.nextToken();
        }
        if (this.gweight) {
            string2 = stringTokenizer.nextToken();
        }
        if (this.gorder) {
            string2 = stringTokenizer.nextToken();
        }
        this.arrayIds = new String[this.columns];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith("ARRY") && string2.endsWith("X")) {
                try {
                    this.arrayIds[n] = string2;
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
    }

    protected final void parseLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", true);
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            if (this.hasGid()) {
                string2 = stringTokenizer.nextToken();
                this.geneIds.add(string2);
                if (!string2.equals("\t") && stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            }
            this.rowNames.add(stringTokenizer.nextToken());
            string2 = stringTokenizer.nextToken();
            if (this.hasColumnName()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("\t")) {
                    this.rowDescriptions.add("");
                } else {
                    this.rowDescriptions.add(string2);
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                }
            }
            if (this.hasGweight() && !(string2 = stringTokenizer.nextToken()).equals("\t") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (this.hasGorder() && !(string2 = stringTokenizer.nextToken()).equals("\t") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
        }
        double[] dArray = new double[this.columns];
        for (int i2 = 0; i2 < this.columns; ++i2) {
            String string3;
            if (!stringTokenizer.hasMoreTokens() || (string3 = stringTokenizer.nextToken()).equals("\t")) continue;
            try {
                dArray[i2] = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                dArray[i2] = Double.NaN;
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = stringTokenizer.nextToken();
        }
        this.values.add(dArray);
    }
}

