/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.snp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.IExpressionDataHandler;
import org.genepattern.io.expr.IExpressionDataParser;

public class SnpParser
implements IExpressionDataParser {
    IExpressionDataHandler handler;
    LineNumberReader reader;
    private String[] tokens;
    private int columns;

    @Override
    public final boolean canDecode(InputStream inputStream) {
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        try {
            return this.readHeader(true);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    @Override
    public final void parse(InputStream inputStream) {
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        this.readHeader(false);
        this.readData();
    }

    private void readData() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = this.reader.readLine();
        while (stringArray != null) {
            arrayList.add(stringArray);
            stringArray = this.reader.readLine();
        }
        stringArray = new String[]{"Chromosome", "PhysicalPosition"};
        String[] stringArray2 = new String[]{"calls"};
        this.handler.init(arrayList.size(), this.columns, stringArray, new String[0], stringArray2);
        int n = 3;
        int n2 = 0;
        while (n < this.tokens.length) {
            this.handler.columnName(n2, this.tokens[n]);
            n += 2;
            ++n2;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n3;
            String string = (String)arrayList.get(n);
            if (string.equals("")) continue;
            String[] stringArray3 = string.split("\t");
            int n4 = stringArray3.length;
            if (n4 != (n3 = this.columns * 2 + 3)) {
                throw new ParseException("Incomplete data on line " + n + ". Expected " + n3 + ", got " + n4 + " tokens.");
            }
            String string2 = stringArray3[0];
            if (this.handler != null) {
                this.handler.rowName(n, string2);
                this.handler.rowMetaData(n, 0, stringArray3[1]);
                this.handler.rowMetaData(n, 1, stringArray3[2]);
            }
            int n5 = 0;
            int n6 = 3;
            while (n5 < this.columns) {
                try {
                    double d2 = Double.parseDouble(stringArray3[n6]);
                    if (this.handler != null) {
                        this.handler.data(n, n5, d2);
                        this.handler.data(n, n5, 0, stringArray3[n6 + 1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Data at line number " + n + " and column " + n5 + " is not a number.");
                }
                ++n5;
                n6 += 2;
            }
        }
    }

    private boolean readHeader(boolean bl) {
        this.tokens = this.reader.readLine().split("\t");
        if (this.tokens == null || this.tokens.length == 0 || this.tokens.length == 1) {
            throw new ParseException("Unable to parse line 1");
        }
        if (bl) {
            return "SNP".equalsIgnoreCase(this.tokens[0]) && "Chromosome".equalsIgnoreCase(this.tokens[1]) && "PhysicalPosition".equalsIgnoreCase(this.tokens[2]);
        }
        this.columns = this.tokens.length - 3;
        if (this.columns % 2 != 0) {
            throw new ParseException("Unable to parse line 1");
        }
        if (this.columns <= 0) {
            throw new ParseException("Number of samples must be greater than zero");
        }
        this.columns /= 2;
        return true;
    }

    @Override
    public final void setHandler(IExpressionDataHandler iExpressionDataHandler) {
        this.handler = iExpressionDataHandler;
    }

    @Override
    public final String getFormatName() {
        return "snp";
    }

    @Override
    public final List getFileSuffixes() {
        return Collections.unmodifiableList(Arrays.asList("snp"));
    }
}

