/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.gct;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.IExpressionDataHandler;
import org.genepattern.io.expr.IExpressionDataParser;

public class GctParser
implements IExpressionDataParser {
    static final String VERSION = "#1.2";
    LineNumberReader reader;
    int rows;
    int columns;
    int version;
    IExpressionDataHandler handler;

    @Override
    public final boolean canDecode(InputStream inputStream) {
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        try {
            this.readHeader();
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    @Override
    public final void parse(InputStream inputStream) {
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        this.readHeader();
        this.readData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readData() {
        int n = 0;
        int n2 = this.columns + 2;
        String string = this.reader.readLine();
        while (true) {
            block10: {
                String[] stringArray;
                block11: {
                    block8: {
                        block9: {
                            if (string == null) break block8;
                            if (n < this.rows) break block9;
                            if (!string.trim().equals("")) {
                                int n3 = n + 1;
                                throw new ParseException("More data rows than expected on line " + this.reader.getLineNumber() + ". Read " + n3 + ", expected " + this.rows + ".");
                            }
                            --n;
                            break block10;
                        }
                        stringArray = string.split("\t");
                        if (stringArray.length != n2) {
                            throw new ParseException(stringArray.length + this.getColumnString(stringArray.length) + " on line " + this.reader.getLineNumber() + ". Expected " + n2 + ".");
                        }
                        String string2 = stringArray[0];
                        if (this.handler != null) {
                            this.handler.rowName(n, string2);
                            this.handler.rowMetaData(n, 0, stringArray[1]);
                        }
                        if (this.handler == null) break block10;
                        break block11;
                    }
                    if (n != this.rows) {
                        throw new ParseException("Missing data rows. Read " + n + " " + this.getRowString(n) + ", expected " + this.rows);
                    }
                    return;
                }
                for (int i2 = 0; i2 < this.columns; ++i2) {
                    try {
                        this.handler.data(n, i2, Double.parseDouble(stringArray[i2 + 2]));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Data at line number " + this.reader.getLineNumber() + " and column " + i2 + " is not a number.");
                    }
                }
            }
            string = this.reader.readLine();
            ++n;
        }
    }

    private final void readHeader() {
        int n;
        String string;
        String[] stringArray;
        String string2 = this.reader.readLine().trim();
        if (!string2.equals(VERSION)) {
            throw new ParseException("Unknown version on line 1.");
        }
        String string3 = this.reader.readLine().trim();
        String[] stringArray2 = string3.split("\t");
        if (stringArray2.length != 2) {
            throw new ParseException("Line number " + this.reader.getLineNumber() + " should contain the number of rows and the number of columns separated by a tab.");
        }
        try {
            this.rows = Integer.parseInt(stringArray2[0]);
            this.columns = Integer.parseInt(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Line number " + this.reader.getLineNumber() + " should contain the number of rows and the number of columns separated by a tab.");
        }
        if (this.rows <= 0 || this.columns <= 0) {
            throw new ParseException("Number of rows and columns must be greater than 0.");
        }
        if (this.handler != null) {
            this.handler.init(this.rows, this.columns, new String[]{"description"}, new String[]{"description"}, new String[0]);
        }
        if ((stringArray = (string = this.reader.readLine()).split("\t")).length != (n = this.columns + 2)) {
            throw new ParseException("Expected " + (n - 2) + " column names, but read " + (stringArray.length - 2) + " column names on line " + this.reader.getLineNumber() + ".");
        }
        for (int i2 = 0; i2 < this.columns; ++i2) {
            String string4 = stringArray[i2 + 2];
            if (this.handler == null) continue;
            this.handler.columnName(i2, string4);
        }
    }

    @Override
    public final void setHandler(IExpressionDataHandler iExpressionDataHandler) {
        this.handler = iExpressionDataHandler;
    }

    protected final String getRowString(int n) {
        if (n == 1) {
            return "row";
        }
        return "rows";
    }

    protected final String getColumnString(int n) {
        if (n == 1) {
            return "column";
        }
        return "columns";
    }

    @Override
    public final String getFormatName() {
        return "gct";
    }

    @Override
    public final List getFileSuffixes() {
        return Collections.unmodifiableList(Arrays.asList("gct"));
    }
}

