/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.cls;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.cls.IClsHandler;

public class ClsParser {
    static final String formatName = "cls";
    List suffixes = Collections.unmodifiableList(Arrays.asList("cls"));
    BufferedReader reader;
    int numClasses;
    int numItems;
    IClsHandler handler;

    public final boolean canDecode(InputStream inputStream) {
        try {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
            this.processHeader();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final void parse(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.read();
    }

    private final void read() {
        this.processHeader();
        String string = this.reader.readLine();
        String[] stringArray = null;
        String string2 = null;
        String[] stringArray2 = null;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (this.hasClassNames(string)) {
            stringArray = this.readClassNamesLine(string);
            int n = stringArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                hashMap.put(new Integer(i2), stringArray[i2]);
            }
            string2 = this.reader.readLine();
            stringArray2 = this.processData(string2, hashMap);
        } else {
            stringArray = new String[this.numClasses];
            for (int i3 = 0; i3 < this.numClasses; ++i3) {
                stringArray[i3] = "" + i3;
                hashMap.put(new Integer(i3), "" + i3);
            }
            string2 = string;
            stringArray2 = this.processData(string2, hashMap);
        }
        if (this.handler != null) {
            this.handler.classes(stringArray);
            this.handler.assignments(stringArray2);
        }
    }

    private boolean hasClassNames(String string) {
        return string != null && string.length() > 2 && string.startsWith("#");
    }

    private void processHeader() {
        String string = this.reader.readLine();
        if (string == null) {
            throw new ParseException("No header line");
        }
        int[] nArray = new int[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        if (stringTokenizer.countTokens() != 3) {
            throw new ParseException("Header line needs three numbers!\n\"" + string + "\"");
        }
        try {
            for (int i2 = 0; i2 < 3; ++i2) {
                nArray[i2] = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Header line element '" + numberFormatException.getMessage() + "' is not a number");
        }
        if (nArray[0] <= 0) {
            throw new ParseException("Header line missing first number, number of data points");
        }
        if (nArray[1] <= 0) {
            throw new ParseException("Header line missing second number, number of classes");
        }
        this.numClasses = nArray[1];
        this.numItems = nArray[0];
    }

    private String[] readClassNamesLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = string.substring(string.indexOf(35) + 1), " \t");
        if (stringTokenizer.countTokens() != this.numClasses) {
            throw new ParseException("First line specifies " + this.numClasses + " classes, but found " + stringTokenizer.countTokens() + ".");
        }
        String[] stringArray = new String[this.numClasses];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private String[] processData(String string, Map map) {
        if (string == null) {
            throw new ParseException("Missing data (numbers seperated by spaces) on 3rd line");
        }
        try {
            String[] stringArray = new String[this.numItems];
            String[] stringArray2 = string.split("[ \t]");
            if (stringArray2.length != this.numItems) {
                throw new ParseException("Header specifies " + this.numItems + " data points, but file contains " + stringArray2.length + " data points.");
            }
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                String string2;
                int n = Integer.parseInt(stringArray2[i2].trim());
                if (n >= this.numClasses || n < 0) {
                    throw new ParseException("Header specifies " + this.numClasses + " classes, but data line contains a " + n + ", a value " + "that is too " + (n < 0 ? "small" : "large") + "." + " All data for this file must be in the range 0-" + (this.numClasses - 1) + ".");
                }
                stringArray[i2] = string2 = (String)map.get(new Integer(n));
            }
            return stringArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("All values on the 3rd lines must be numbers.");
        }
    }

    public final void setHandler(IClsHandler iClsHandler) {
        this.handler = iClsHandler;
    }

    public final String getFormatName() {
        return formatName;
    }

    public final List getFileSuffixes() {
        return this.suffixes;
    }
}

