/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.List;
import org.genepattern.io.IOdfHandler;
import org.genepattern.io.ParseException;

public class OdfParser {
    IOdfHandler handler;
    LineNumberReader reader;
    int dataLines;
    private static final String COMMENT = "#";
    static final List VERSIONS = Arrays.asList("ODF 1.0", "SDF 1.0");

    public final void parse(InputStream inputStream) {
        this.reader = new LineNumberReader(new InputStreamReader(inputStream));
        this.parseHeader();
        this.parseData();
    }

    private String readLine() {
        String string = this.reader.readLine();
        if (string != null && string.trim().startsWith(COMMENT)) {
            return this.readLine();
        }
        if (string != null && string.trim().equals("")) {
            return this.readLine();
        }
        return string;
    }

    public final boolean canDecode(InputStream inputStream) {
        this.reader = new LineNumberReader(new InputStreamReader(inputStream));
        return this.isSupportedVersion(this.readLine());
    }

    private final void parseData() {
        int n;
        if (this.dataLines == 0) {
            return;
        }
        String string = this.readLine().trim();
        String[] stringArray = string.split("\t");
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            if (this.handler == null) continue;
            this.handler.data(0, n, stringArray[n]);
        }
        for (n = 1; n < this.dataLines; ++n) {
            int n3;
            string = this.readLine().trim();
            if (string == null) {
                n3 = n + 1;
                throw new ParseException("Unexpected end of file on line " + this.reader.getLineNumber() + ".");
            }
            stringArray = string.split("\t");
            if (stringArray.length != n2) {
                throw new ParseException("Expecting " + n2 + " tokens on line " + this.reader.getLineNumber() + ", but found " + stringArray.length + " tokens.");
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (this.handler == null) continue;
                this.handler.data(n, n3, stringArray[n3].trim());
            }
        }
        String string2 = this.readLine();
        while (string2 != null) {
            if (!string2.trim().equals("")) {
                throw new ParseException("Extra data rows on line " + this.reader.getLineNumber() + ".");
            }
            string2 = this.readLine();
        }
    }

    private final void parseHeader() {
        String string = this.readLine();
        if (!this.isSupportedVersion(string)) {
            throw new ParseException("First line must be one of " + VERSIONS);
        }
        int n = 0;
        try {
            n = this.getIntValue(this.readLine());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Header lines is not a number.");
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n; ++i2) {
            String string2;
            String string3;
            String string4 = this.readLine();
            int n2 = 0;
            int n3 = string4.indexOf("=");
            int n4 = string4.indexOf(":");
            if (n3 == -1 && n4 == -1) {
                throw new ParseException("Invalid header: " + string4 + " on line " + this.reader.getLineNumber());
            }
            if (n4 == -1) {
                n4 = Integer.MAX_VALUE;
            }
            if (n3 == -1) {
                n3 = Integer.MAX_VALUE;
            }
            if (n3 > 0 && n3 < n4) {
                n2 = n3;
                string3 = string4.substring(0, n2).trim();
                string2 = string4.substring(n2 + 1, string4.length());
                string3 = string3.trim();
                string2 = string2.trim();
                if (this.handler != null) {
                    this.handler.header(string3, string2);
                }
                if (string3.equalsIgnoreCase("model")) {
                    bl = true;
                }
                if (!string3.equalsIgnoreCase("DataLines")) continue;
                bl2 = true;
                try {
                    this.dataLines = Integer.parseInt(string2);
                    if (this.dataLines >= 0) continue;
                    throw new ParseException(string3 + " must be >= 0.");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(string3 + " is not a number.");
                }
            }
            if (n4 > 0 && n4 < n3) {
                n2 = n4;
                string3 = string4.substring(0, n2);
                string3 = string3.trim();
                string2 = string4.substring(n2 + 1, string4.length());
                string2 = string2.trim();
                String[] stringArray = string2.split("\t");
                if (this.handler == null) continue;
                this.handler.header(string3, stringArray);
                continue;
            }
            throw new ParseException("Invalid header " + string4 + " on line " + this.reader.getLineNumber());
        }
        if (!bl2) {
            throw new ParseException("Missing DataLines header");
        }
        if (!bl) {
            throw new ParseException("Missing Model header");
        }
        if (this.handler != null) {
            this.handler.endHeader();
        }
    }

    public final void setHandler(IOdfHandler iOdfHandler) {
        this.handler = iOdfHandler;
    }

    private final boolean isSupportedVersion(String string) {
        if (string == null) {
            return false;
        }
        string = string.trim();
        for (int i2 = 0; i2 < VERSIONS.size(); ++i2) {
            String string2 = (String)VERSIONS.get(i2);
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private int getIntValue(String string) {
        String[] stringArray = string.split("=");
        return Integer.parseInt(stringArray[1].trim());
    }
}

