/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Point;
import javax.swing.JComponent;

public class PixelConverter {
    private JComponent component;
    int rowSize;
    int columnSize;

    public PixelConverter(JComponent jComponent) {
        this.component = jComponent;
    }

    public final void setColumnSize(int n) {
        this.columnSize = n;
    }

    public final void setRowSize(int n) {
        this.rowSize = n;
    }

    public final int getLeftIndex(int n) {
        if (n < this.component.getInsets().left) {
            return 0;
        }
        return (n - this.component.getInsets().left) / this.columnSize;
    }

    public final int getTopIndex(int n) {
        if (n < this.component.getInsets().top) {
            return 0;
        }
        return (n - this.component.getInsets().top) / this.rowSize;
    }

    public final int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.columnSize + 1;
        return n3 > n2 ? n2 : n3;
    }

    public final int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.rowSize + 1;
        return n3 > n2 ? n2 : n3;
    }

    public final int columnAtPoint(Point point) {
        return (int)((point.getX() - (double)this.component.getInsets().left) / (double)this.columnSize);
    }

    public final int rowAtPoint(Point point) {
        return (int)((point.getY() - (double)this.component.getInsets().top) / (double)this.rowSize);
    }
}

