/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.genepattern.heatmap.RowColorScheme;

public class LegendPanel
extends JPanel {
    public static final NumberFormat ONE_FRACTION_FORMAT = NumberFormat.getInstance();
    public static final NumberFormat NO_FRACTION_FORMAT = NumberFormat.getInstance();

    final void setAbsoluteGrid(RowColorScheme rowColorScheme) {
        double[] dArray = rowColorScheme.getSlots();
        this.setDisplayValues(rowColorScheme.getColorMap(), dArray, "", NO_FRACTION_FORMAT, 2);
    }

    final void setRelativeGrid(RowColorScheme rowColorScheme) {
        double[] dArray = new double[rowColorScheme.getColorCount()];
        rowColorScheme.calculateSlots(-3.0, 3.0, 0.0, dArray);
        double[] dArray2 = new double[dArray.length + 1];
        dArray2[0] = -3.0;
        System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        this.setDisplayValues(rowColorScheme.getColorMap(), dArray2, "Normalized Expression", ONE_FRACTION_FORMAT, 2);
    }

    public final void setDisplayValues(Color[] colorArray, double[] dArray, String string, NumberFormat numberFormat, int n) {
        String[] stringArray = new String[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            stringArray[i2] = numberFormat.format(dArray[i2]);
        }
        this.setDisplayValues(colorArray, stringArray, string, n);
    }

    public final void setDisplayValues(Color[] colorArray, String[] stringArray, String string, int n) {
        JComponent jComponent;
        JComponent jComponent2;
        this.removeAll();
        this.setBackground(Color.white);
        int n2 = colorArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 600;
        int n4 = n3 / n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(n4 + "px");
        }
        stringBuffer.append(", pref");
        JPanel jPanel = new JPanel(new FormLayout(stringBuffer.toString(), "pref, pref"));
        jPanel.setBackground(Color.white);
        CellConstraints cellConstraints = new CellConstraints();
        for (int i3 = 0; i3 < n2; ++i3) {
            jComponent2 = new JPanel();
            jComponent2.setToolTipText(stringArray[i3]);
            jComponent2.setBackground(colorArray[i3]);
            jComponent2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jComponent = new JLabel(stringArray[i3]);
            jComponent.setToolTipText(stringArray[i3]);
            ((JLabel)jComponent).setHorizontalAlignment(n);
            jPanel.add((Component)jComponent2, cellConstraints.xy(i3 + 1, 1));
            jPanel.add((Component)jComponent, cellConstraints.xy(i3 + 1, 2));
        }
        if (stringArray.length > colorArray.length) {
            JLabel jLabel = new JLabel(stringArray[stringArray.length - 1]);
            jLabel.setToolTipText(stringArray[stringArray.length - 1]);
            jPanel.add((Component)jLabel, cellConstraints.xy(stringArray.length, 2));
            jLabel.setHorizontalAlignment(n);
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.add(jPanel);
        this.add(jPanel2);
        jComponent2 = new JLabel(string, 0);
        jComponent = new JPanel();
        jComponent.setBackground(Color.white);
        jComponent.add(jComponent2);
        this.add((Component)jComponent, "South");
    }

    static {
        ONE_FRACTION_FORMAT.setMaximumFractionDigits(1);
        ONE_FRACTION_FORMAT.setMinimumFractionDigits(1);
        NO_FRACTION_FORMAT.setMaximumFractionDigits(0);
        NO_FRACTION_FORMAT.setMinimumFractionDigits(0);
    }
}

