/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.CellConstraints$Alignment;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.genepattern.annotation.FeatureAnnotatorPanel;
import org.genepattern.annotation.SampleAnnotatorPanel;
import org.genepattern.annotation.SetAnnotator;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.clustering.hierarchical.ArrayTreePanel;
import org.genepattern.clustering.hierarchical.GeneTreePanel;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapComponent$1;
import org.genepattern.heatmap.HeatMapComponent$10;
import org.genepattern.heatmap.HeatMapComponent$11;
import org.genepattern.heatmap.HeatMapComponent$12;
import org.genepattern.heatmap.HeatMapComponent$13;
import org.genepattern.heatmap.HeatMapComponent$14;
import org.genepattern.heatmap.HeatMapComponent$15;
import org.genepattern.heatmap.HeatMapComponent$16;
import org.genepattern.heatmap.HeatMapComponent$2;
import org.genepattern.heatmap.HeatMapComponent$3;
import org.genepattern.heatmap.HeatMapComponent$4;
import org.genepattern.heatmap.HeatMapComponent$5;
import org.genepattern.heatmap.HeatMapComponent$6;
import org.genepattern.heatmap.HeatMapComponent$7;
import org.genepattern.heatmap.HeatMapComponent$8;
import org.genepattern.heatmap.HeatMapComponent$9;
import org.genepattern.heatmap.HeatMapComponent$DendrogramColorEditor;
import org.genepattern.heatmap.HeatMapComponent$OptionsDialog;
import org.genepattern.heatmap.HeatMapComponent$SaveDataset;
import org.genepattern.heatmap.HeatMapPanel;
import org.genepattern.heatmap.image.FeatureAnnotator;
import org.genepattern.heatmap.image.SampleAnnotator;
import org.genepattern.menu.FileMenu;
import org.genepattern.menu.FindAction;
import org.genepattern.module.VisualizerUtil;
import org.genepattern.plot.ProfilePlot;
import org.genepattern.uiutil.CenteredDialog;
import org.genepattern.uiutil.FileChooser;
import org.genepattern.uiutil.UIUtil;
import org.genepattern.uiutil.VerticalLabelUI2;

public class HeatMapComponent
extends JComponent {
    private Component accessoryComponent;
    private boolean allowChangeColumnNameVisibility = true;
    private boolean allowChangeRowDescriptionsVisibility = true;
    private boolean allowChangeRowNameVisibility = true;
    private JPanel bottomPanel;
    private IExpressionData data;
    private FeatureAnnotatorPanel featureAnnotatorPanel;
    private JTable featureTable;
    private AbstractTableModel featureTableModel;
    private String featureUIString = "Feature";
    private HeatMapComponent$DendrogramColorEditor geneDendrogramColorEditor;
    private GeneTreePanel geneTree;
    private JPanel heatMapAndAnnotatorPanel;
    private HeatMapPanel heatMapPanel;
    protected HeatMapComponent$OptionsDialog optionsDialog;
    private Frame parent;
    private ProfilePlot plot;
    private JPopupMenu popupMenu;
    private boolean showPopupMenu = true;
    private SampleAnnotatorPanel sampleAnnotatorPanel;
    private HeatMapComponent$DendrogramColorEditor sampleDendrogramColorEditor;
    private JTable sampleTable;
    private AbstractTableModel sampleTableModel;
    private ArrayTreePanel sampleTree;
    private String sampleUIString = "Sample";
    private HeatMapComponent$SaveDataset saveDataset;
    private JScrollPane scrollPane;
    private SetAnnotator setFeatureAnnotator;
    private SetAnnotator setSampleAnnotator;
    private boolean showColorSchemeOptions = true;
    private boolean showColumnNames = true;
    private boolean showRowDescriptions = true;
    private boolean showRowNames = true;
    private JLabel statusLabel = new JLabel("");
    private JPanel topPanel;

    public static final Map getFeatureName2ColorsMap(SparseClassVector sparseClassVector, IExpressionData iExpressionData, boolean bl) {
        int n;
        HashMap hashMap = new HashMap();
        int n2 = n = bl ? iExpressionData.getRowCount() : iExpressionData.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            List list = sparseClassVector.getClassNumbers(i2);
            if (list == null || list.size() <= 0) continue;
            String string = bl ? iExpressionData.getRowName(i2) : iExpressionData.getColumnName(i2);
            ArrayList<Color> arrayList = new ArrayList<Color>();
            hashMap.put(string, arrayList);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Integer n3 = (Integer)list.get(i3);
                arrayList.add(sparseClassVector.getColor(n3));
            }
        }
        return hashMap;
    }

    public HeatMapComponent(Frame frame, IExpressionData iExpressionData) {
        this(frame, iExpressionData, null, null);
    }

    public HeatMapComponent(Frame frame, IExpressionData iExpressionData, GeneTreePanel geneTreePanel, ArrayTreePanel arrayTreePanel) {
        this(frame, iExpressionData, geneTreePanel, arrayTreePanel, null);
    }

    public HeatMapComponent(Frame frame, IExpressionData iExpressionData, GeneTreePanel geneTreePanel, ArrayTreePanel arrayTreePanel, Component component) {
        this.accessoryComponent = component;
        this.parent = frame;
        this.geneTree = geneTreePanel;
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Profile");
        jMenuItem.addActionListener(new HeatMapComponent$1(this));
        this.popupMenu.add(jMenuItem);
        if (geneTreePanel != null) {
            geneTreePanel.addListSelectionListener(new HeatMapComponent$2(this));
            this.geneDendrogramColorEditor = new HeatMapComponent$DendrogramColorEditor(frame, geneTreePanel);
        }
        this.sampleTree = arrayTreePanel;
        if (arrayTreePanel != null) {
            arrayTreePanel.addListSelectionListener(new HeatMapComponent$3(this));
            this.sampleDendrogramColorEditor = new HeatMapComponent$DendrogramColorEditor(frame, arrayTreePanel);
        }
        this.data = iExpressionData;
        this.saveDataset = new HeatMapComponent$SaveDataset(this);
        this.heatMapPanel = new HeatMapPanel(this.data);
        this.featureTableModel = this.createRowTableModel();
        String[] stringArray = new String[this.data.getRowCount()];
        int n = this.data.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = this.data.getRowName(i2);
        }
        this.setFeatureAnnotator = new SetAnnotator(frame, new HeatMapComponent$4(this), true);
        this.featureTable = new HeatMapComponent$5(this, this.featureTableModel);
        this.featureTable.setColumnSelectionAllowed(false);
        this.featureTable.setGridColor(new Color(239, 239, 255));
        this.featureTable.setRowHeight(this.heatMapPanel.getRowSize());
        this.featureTable.setFont(new Font("monospaced", 0, this.heatMapPanel.getRowSize()));
        this.sampleTableModel = new HeatMapComponent$6(this);
        this.setSampleAnnotator = new SetAnnotator(frame, new HeatMapComponent$7(this), false);
        this.sampleTable = new HeatMapComponent$8(this, null);
        ((JLabel)((Object)this.sampleTable.getDefaultRenderer(String.class))).setUI(new VerticalLabelUI2(false));
        this.sampleTable.setRowSelectionAllowed(false);
        this.sampleTable.setModel(this.sampleTableModel);
        this.sampleTable.setGridColor(new Color(239, 239, 255));
        this.sampleTable.setColumnSelectionAllowed(true);
        System.setProperty("org.genepattern.menu.showAccelerators", "false");
        this.plot = new ProfilePlot(frame, this.data);
        System.setProperty("org.genepattern.menu.showAccelerators", "true");
        FormLayout formLayout = new FormLayout("pref, pref, pref:g(1)", "pref");
        CellConstraints cellConstraints = new CellConstraints();
        this.bottomPanel = new JPanel(formLayout);
        if (geneTreePanel != null) {
            this.bottomPanel.add((Component)geneTreePanel, cellConstraints.xy(1, 1, CellConstraints.LEFT, CellConstraints.TOP));
        }
        this.heatMapAndAnnotatorPanel = new JPanel(new FormLayout("pref, pref", "pref"));
        this.heatMapAndAnnotatorPanel.add((Component)this.heatMapPanel, cellConstraints.xy(1, 1, CellConstraints.FILL, CellConstraints.TOP));
        this.featureAnnotatorPanel = new FeatureAnnotatorPanel(this.setFeatureAnnotator.getClassVector(), iExpressionData, this.heatMapPanel.getRowSize(), this.heatMapAndAnnotatorPanel);
        this.heatMapAndAnnotatorPanel.add((Component)this.featureAnnotatorPanel, cellConstraints.xy(2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        this.bottomPanel.add((Component)this.heatMapAndAnnotatorPanel, cellConstraints.xy(2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 1, 0, 0));
        jPanel.add(this.featureTable);
        this.bottomPanel.add((Component)jPanel, cellConstraints.xy(3, 1, CellConstraints.FILL, CellConstraints.TOP));
        this.topPanel = new JPanel(new FormLayout("pref, pref:g", "pref, pref, pref"));
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(0, geneTreePanel != null ? geneTreePanel.getPreferredSize().width + 2 : 2, 0, 0));
        this.topPanel.add((Component)this.sampleTable, cellConstraints.xy(1, 2));
        this.topPanel.add((Component)this.featureTable.getTableHeader(), cellConstraints.xy(2, 3, CellConstraints.FILL, CellConstraints.BOTTOM));
        if (arrayTreePanel != null) {
            this.topPanel.add((Component)arrayTreePanel, cellConstraints.xywh(1, 1, 2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        }
        this.setAccessoryComponent(component, 1);
        this.sampleAnnotatorPanel = new SampleAnnotatorPanel(this.setSampleAnnotator.getClassVector(), iExpressionData, this.heatMapPanel.getColumnSize(), this.topPanel);
        this.topPanel.add((Component)this.sampleAnnotatorPanel, cellConstraints.xywh(1, 3, 2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        this.scrollPane = new JScrollPane(this.bottomPanel);
        this.scrollPane.setColumnHeaderView(this.topPanel);
        this.setColumnSize(this.heatMapPanel.getColumnSize());
        this.layoutSampleTable(this.heatMapPanel.getColumnSize());
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.statusLabel, "South");
    }

    public final JMenuBar createMenuBar(boolean bl) {
        return this.createMenuBar(bl, true, true);
    }

    public final JMenuBar createMenuBar(boolean bl, boolean bl2, boolean bl3) {
        return this.createMenuBar(bl, bl2, bl3, true);
    }

    public final JMenuBar createMenuBar(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        if (bl3) {
            jMenu.add(this.setFeatureAnnotator.getOpenFeaturesMenuItem());
            jMenu.add(this.setSampleAnnotator.getOpenFeaturesMenuItem());
        }
        JMenuItem jMenuItem3 = new JMenuItem("Save Dataset...");
        jMenu.add(jMenuItem3);
        JMenu jMenu2 = new JMenu("Save Image");
        JMenuItem jMenuItem4 = new JMenuItem("bmp...");
        JMenuItem jMenuItem5 = new JMenuItem("jpeg...");
        JMenuItem jMenuItem6 = new JMenuItem("png...");
        JMenuItem jMenuItem7 = new JMenuItem("tiff...");
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        jMenu2.add(jMenuItem6);
        jMenu2.add(jMenuItem7);
        jMenu.add(jMenu2);
        if (bl) {
            jMenu.add(FileMenu.createExitMenuItem());
        }
        JMenu jMenu3 = new JMenu("Edit");
        JMenu jMenu4 = new JMenu("View");
        if (this.geneTree != null) {
            jMenuItem2 = new JMenuItem(this.featureUIString + " Dendrogram Color...");
            jMenuItem2.addActionListener(new HeatMapComponent$9(this));
            jMenu3.add(jMenuItem2);
            jMenuItem = new JMenuItem("Flip " + this.featureUIString + "Dendrogram");
            jMenuItem.addActionListener(new HeatMapComponent$10(this));
            jMenu4.add(jMenuItem);
        }
        if (this.sampleTree != null) {
            jMenuItem2 = new JMenuItem(this.sampleUIString + " Dendrogram Color...");
            jMenuItem2.addActionListener(new HeatMapComponent$11(this));
            jMenu3.add(jMenuItem2);
            jMenuItem = new JMenuItem("Flip " + this.sampleUIString + "Dendrogram");
            jMenuItem.addActionListener(new HeatMapComponent$12(this));
            jMenu4.add(jMenuItem);
        }
        if (bl3) {
            jMenu3.add(this.setFeatureAnnotator.getViewFeatureListsMenuItem());
            jMenu3.add(this.setSampleAnnotator.getViewFeatureListsMenuItem());
        }
        jMenuItem2 = new JMenuItem("Legend");
        jMenu4.add(jMenuItem2);
        jMenuItem = new JMenuItem("Profile");
        jMenu4.add(jMenuItem);
        jMenu3.add(new JSeparator());
        JMenuItem jMenuItem8 = new JMenuItem("Display Options...");
        jMenu3.add(jMenuItem8);
        HeatMapComponent$13 heatMapComponent$13 = new HeatMapComponent$13(this, jMenuItem3, jMenuItem, jMenuItem2, jMenuItem4, jMenuItem5, jMenuItem7, jMenuItem6);
        jMenuItem2.addActionListener(heatMapComponent$13);
        jMenuItem.addActionListener(heatMapComponent$13);
        jMenuItem8.addActionListener(heatMapComponent$13);
        jMenuItem4.addActionListener(heatMapComponent$13);
        jMenuItem5.addActionListener(heatMapComponent$13);
        jMenuItem6.addActionListener(heatMapComponent$13);
        jMenuItem7.addActionListener(heatMapComponent$13);
        jMenuItem3.addActionListener(heatMapComponent$13);
        if (bl2) {
            jMenu3.add(new JSeparator());
            jMenu3.add(new FindAction(this.parent, this.featureTable, this.data, 0));
        }
        jMenuBar.add(jMenu3);
        if (bl4) {
            jMenuBar.add(jMenu4);
        }
        return jMenuBar;
    }

    private AbstractTableModel createRowTableModel() {
        HeatMapComponent$14 heatMapComponent$14 = new HeatMapComponent$14(this);
        return heatMapComponent$14;
    }

    public final void disposeFrame() {
        this.parent.dispose();
    }

    protected final void fireFeatureTableChanged() {
        this.featureTableModel.fireTableChanged(new TableModelEvent(this.featureTableModel, -1));
    }

    public final IExpressionData getExpressionData() {
        return this.data;
    }

    public final JTable getFeatureTable() {
        return this.featureTable;
    }

    public final Frame getFrame() {
        return this.parent;
    }

    public final HeatMapPanel getHeatMapPanel() {
        return this.heatMapPanel;
    }

    public final String getRowNameHeader() {
        return this.featureUIString;
    }

    public final JTable getSampleTable() {
        return this.sampleTable;
    }

    public final boolean isShowColumnNames() {
        return this.showColumnNames;
    }

    public final boolean isShowRowDescriptions() {
        return this.showRowDescriptions;
    }

    public final boolean isShowRowNames() {
        return this.showRowNames;
    }

    private void layoutSampleTable(int n) {
        for (int i2 = 0; i2 < this.sampleTable.getColumnCount(); ++i2) {
            TableColumn tableColumn = this.sampleTable.getColumnModel().getColumn(i2);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setPreferredWidth(n);
            tableColumn.setWidth(n);
        }
    }

    private void layoutSampleTableColumn(TableColumn tableColumn, int n) {
        tableColumn.setMinWidth(n);
        tableColumn.setMaxWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn.setWidth(n);
    }

    public final void setAccessoryComponent(Component component, int n) {
        if (this.accessoryComponent != null) {
            this.topPanel.remove(this.accessoryComponent);
        }
        this.accessoryComponent = component;
        if (this.accessoryComponent != null) {
            CellConstraints cellConstraints = new CellConstraints();
            int n2 = n == 1 ? 2 : 1;
            CellConstraints$Alignment cellConstraints$Alignment = n == 1 ? CellConstraints.TOP : CellConstraints.BOTTOM;
            this.topPanel.add(this.accessoryComponent, cellConstraints.xywh(n, 1, n2, 1, CellConstraints.LEFT, cellConstraints$Alignment));
        }
    }

    public final void setColorConverter(ColorScheme colorScheme) {
        this.heatMapPanel.setColorConverter(colorScheme);
    }

    public final void setColumnSize(int n) {
        if (this.sampleTree != null) {
            this.sampleTree.setElementWidth(n);
        }
        this.heatMapPanel.setColumnSize(n);
        this.layoutSampleTable(n);
        this.sampleTable.setFont(new Font("monospaced", 0, n));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("monospaced", 0, n));
        int n2 = 0;
        for (int i2 = 0; i2 < this.data.getColumnCount(); ++i2) {
            jLabel.setText(this.data.getColumnName(i2));
            n2 = Math.max(n2, jLabel.getPreferredSize().width);
        }
        this.sampleAnnotatorPanel.setColumnSize(n);
        this.sampleTable.setRowHeight(n2 + 10);
        this.heatMapAndAnnotatorPanel.invalidate();
        this.heatMapAndAnnotatorPanel.validate();
    }

    public final void setExpressionData(IExpressionData iExpressionData) {
        this.data = iExpressionData;
        this.heatMapPanel.setExpressionData(iExpressionData);
        this.featureTableModel.fireTableStructureChanged();
        this.sampleTableModel.fireTableStructureChanged();
        this.setColumnSize(this.heatMapPanel.getColumnSize());
        this.plot = new ProfilePlot(this.parent, this.data);
    }

    public final void setFeatureAnnotator(FeatureAnnotator featureAnnotator) {
        this.featureAnnotatorPanel.setFeatureAnnotator(featureAnnotator);
    }

    public final void setFeatureTreeHeight(int n) {
        this.geneTree.setPreferredSize(new Dimension(n, this.geneTree.getPreferredSize().height));
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(0, this.geneTree != null ? this.geneTree.getPreferredSize().width + 2 : 2, 0, 0));
    }

    public final void setFeatureUIString(String string) {
        this.featureUIString = string;
    }

    public final void setOptionsDialogOptions(boolean bl, boolean bl2, boolean bl3) {
        this.allowChangeColumnNameVisibility = bl;
        this.allowChangeRowNameVisibility = bl2;
        this.allowChangeRowDescriptionsVisibility = bl3;
    }

    public final void setRowSize(int n) {
        if (this.geneTree != null) {
            this.geneTree.setElementHeight(n);
        }
        this.featureAnnotatorPanel.setRowSize(n);
        this.featureTable.setRowHeight(n);
        this.heatMapPanel.setRowSize(n);
        this.featureTable.setFont(new Font("monospaced", 0, n));
    }

    public final void setSampleAnnotator(SampleAnnotator sampleAnnotator) {
        String[] stringArray = new String[this.data.getColumnCount()];
        for (int i2 = 0; i2 < this.data.getColumnCount(); ++i2) {
            stringArray[i2] = this.data.getColumnName(i2);
        }
        this.sampleAnnotatorPanel.setSampleAnnotator(sampleAnnotator);
        this.setColumnSize(this.heatMapPanel.getColumnSize());
        this.sampleTableModel.fireTableStructureChanged();
    }

    public final void setSampleTreeHeight(int n) {
        this.sampleTree.setPreferredSize(new Dimension(this.sampleTree.getPreferredSize().width, n));
        this.topPanel.revalidate();
        this.scrollPane.revalidate();
    }

    public final void setSampleUIString(String string) {
        this.sampleUIString = string;
    }

    public final void setShowColorSchemeOptions(boolean bl) {
        this.showColorSchemeOptions = bl;
    }

    public final void setShowColumnNames(boolean bl) {
        if (this.showColumnNames == bl) {
            return;
        }
        this.showColumnNames = bl;
        this.sampleTableModel.fireTableStructureChanged();
    }

    public final void setShowFeatureAnnotator(boolean bl) {
        this.setFeatureAnnotator.getOpenFeaturesMenuItem().setVisible(bl);
        this.setFeatureAnnotator.getViewFeatureListsMenuItem().setVisible(bl);
    }

    public final void setShowFeatureTableHeader(boolean bl) {
        this.featureTable.getTableHeader().setVisible(bl);
    }

    public final void setShowRowDescriptions(boolean bl) {
        if (this.showRowDescriptions == bl) {
            return;
        }
        this.showRowDescriptions = bl;
        this.fireFeatureTableChanged();
    }

    public final void setShowRowNames(boolean bl) {
        if (this.showRowNames == bl) {
            return;
        }
        this.showRowNames = bl;
        this.fireFeatureTableChanged();
    }

    public final void setShowSampleAnnotator(boolean bl) {
        this.setSampleAnnotator.getOpenFeaturesMenuItem().setVisible(bl);
        this.setSampleAnnotator.getViewFeatureListsMenuItem().setVisible(bl);
    }

    public final void showFrame() {
        VisualizerUtil.showFrame(this.parent);
    }

    public final void showLegend() {
        CenteredDialog centeredDialog = new CenteredDialog(this.parent);
        centeredDialog.setTitle("Legend");
        Component component = this.heatMapPanel.getColorConverter().getLegend();
        centeredDialog.getContentPane().add(component);
        centeredDialog.pack();
        ((Dialog)centeredDialog).setVisible(true);
    }

    public final void showOptionsDialog() {
        if (this.optionsDialog != null && this.optionsDialog.isShowing()) {
            this.optionsDialog.toFront();
        } else {
            this.optionsDialog = new HeatMapComponent$OptionsDialog(this.parent, this, this.heatMapPanel, this.allowChangeColumnNameVisibility, this.allowChangeRowNameVisibility, this.allowChangeRowDescriptionsVisibility);
        }
    }

    public final void showProfilePlot() {
        int[] nArray = this.featureTable.getSelectedRows();
        if (nArray.length == 0) {
            UIUtil.showMessageDialog(this.parent, "Please select " + Character.toLowerCase(this.featureUIString.charAt(0)) + this.featureUIString.substring(1, this.featureUIString.length()) + "s to view.");
            return;
        }
        new HeatMapComponent$15(this, nArray).start();
    }

    public final void showSaveDatasetDialog() {
        this.saveDataset.show();
    }

    public final void showSaveImageDialog(String string) {
        File file = FileChooser.showSaveDialog(this.parent);
        if (file != null) {
            new HeatMapComponent$16(this, file, string).start();
        }
    }

    public final boolean isShowPopupMenu() {
        return this.showPopupMenu;
    }

    public final void setShowPopupMenu(boolean bl) {
        this.showPopupMenu = bl;
    }

    static final /* synthetic */ boolean access$000(HeatMapComponent heatMapComponent) {
        return heatMapComponent.showColorSchemeOptions;
    }

    static final /* synthetic */ String access$100(HeatMapComponent heatMapComponent) {
        return heatMapComponent.featureUIString;
    }

    static final /* synthetic */ String access$200(HeatMapComponent heatMapComponent) {
        return heatMapComponent.sampleUIString;
    }

    static final /* synthetic */ GeneTreePanel access$300(HeatMapComponent heatMapComponent) {
        return heatMapComponent.geneTree;
    }

    static final /* synthetic */ ArrayTreePanel access$400(HeatMapComponent heatMapComponent) {
        return heatMapComponent.sampleTree;
    }

    static final /* synthetic */ JTable access$500(HeatMapComponent heatMapComponent) {
        return heatMapComponent.featureTable;
    }

    static final /* synthetic */ Frame access$600(HeatMapComponent heatMapComponent) {
        return heatMapComponent.parent;
    }

    static final /* synthetic */ IExpressionData access$700(HeatMapComponent heatMapComponent) {
        return heatMapComponent.data;
    }

    static final /* synthetic */ JTable access$800(HeatMapComponent heatMapComponent) {
        return heatMapComponent.sampleTable;
    }

    static final /* synthetic */ boolean access$900(HeatMapComponent heatMapComponent) {
        return heatMapComponent.showPopupMenu;
    }

    static final /* synthetic */ JPopupMenu access$1000(HeatMapComponent heatMapComponent) {
        return heatMapComponent.popupMenu;
    }

    static final /* synthetic */ boolean access$1100(HeatMapComponent heatMapComponent) {
        return heatMapComponent.showColumnNames;
    }

    static final /* synthetic */ HeatMapPanel access$1200(HeatMapComponent heatMapComponent) {
        return heatMapComponent.heatMapPanel;
    }

    static final /* synthetic */ void access$1300(HeatMapComponent heatMapComponent, TableColumn tableColumn, int n) {
        heatMapComponent.layoutSampleTableColumn(tableColumn, n);
    }

    static final /* synthetic */ HeatMapComponent$DendrogramColorEditor access$1400(HeatMapComponent heatMapComponent) {
        return heatMapComponent.geneDendrogramColorEditor;
    }

    static final /* synthetic */ SetAnnotator access$1500(HeatMapComponent heatMapComponent) {
        return heatMapComponent.setFeatureAnnotator;
    }

    static final /* synthetic */ HeatMapComponent$DendrogramColorEditor access$1600(HeatMapComponent heatMapComponent) {
        return heatMapComponent.sampleDendrogramColorEditor;
    }

    static final /* synthetic */ SetAnnotator access$1700(HeatMapComponent heatMapComponent) {
        return heatMapComponent.setSampleAnnotator;
    }

    static final /* synthetic */ HeatMapComponent$SaveDataset access$1800(HeatMapComponent heatMapComponent) {
        return heatMapComponent.saveDataset;
    }

    static final /* synthetic */ boolean access$1900(HeatMapComponent heatMapComponent) {
        return heatMapComponent.showRowNames;
    }

    static final /* synthetic */ boolean access$2000(HeatMapComponent heatMapComponent) {
        return heatMapComponent.showRowDescriptions;
    }

    static final /* synthetic */ ProfilePlot access$2100(HeatMapComponent heatMapComponent) {
        return heatMapComponent.plot;
    }
}

