/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.Lm;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.utils.ZipUtility;
import edu.mit.broad.xbench.core.Widget;
import foxtrot.Worker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.genepattern.gsea.LeadingEdgeAnalysis;
import org.genepattern.gsea.LeadingEdgeWidget$1;
import org.genepattern.gsea.LeadingEdgeWidget$2;
import org.genepattern.gsea.LeadingEdgeWidget$3;
import org.genepattern.gsea.LeadingEdgeWidget$4;
import org.genepattern.gsea.LeadingEdgeWidget$5;
import org.genepattern.gsea.LeadingEdgeWidget$ESRenderer;
import org.genepattern.gsea.LeadingEdgeWidget$MyTableModel;
import org.genepattern.gsea.ViewAndSearchComponent;
import org.genepattern.gsea.XToolsMessageHandler;
import org.genepattern.uiutil.OS;
import org.genepattern.uiutil.UIUtil;

public class LeadingEdgeWidget
implements Widget {
    private static final Icon ICON = JarResources.getIcon("Lev16_b.gif");
    private EnrichmentDb edb;
    JideTabbedPane tabbedPane;
    static int runs = 0;
    private ViewAndSearchComponent viewAndSearchComponent;
    private JLabel positiveLabel;
    private JLabel negativeLabel;
    private JPanel phenotypePanel;
    private boolean runningInGenePattern;
    private JFileChooser htmlReportDirChooser;
    static final int GENE_SET_INDEX = 0;
    static final int SCORE_INDEX = 2;

    public LeadingEdgeWidget(EnrichmentDb enrichmentDb) {
        if (enrichmentDb == null) {
            throw new IllegalArgumentException("Param edb cannot be null");
        }
        this.runningInGenePattern = true;
        this.tabbedPane = new JideTabbedPane();
        this.tabbedPane.setHideOneTab(true);
        this.tabbedPane.setTabEditingAllowed(true);
        this.tabbedPane.setShowCloseButtonOnTab(true);
        this.edb = enrichmentDb;
        this.init(enrichmentDb);
        this.tabbedPane.addTab("GSEA Results", this.viewAndSearchComponent);
        this.tabbedPane.setTabClosableAt(0, false);
    }

    public LeadingEdgeWidget(JideTabbedPane jideTabbedPane, EnrichmentDb enrichmentDb) {
        if (enrichmentDb == null) {
            throw new IllegalArgumentException("Param edb cannot be null");
        }
        this.runningInGenePattern = false;
        this.tabbedPane = jideTabbedPane;
        UIUtil.setMessageHandler(new XToolsMessageHandler());
        this.edb = enrichmentDb;
        this.init(enrichmentDb);
        jideTabbedPane.addTab("GSEA Results", this.viewAndSearchComponent);
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    @Override
    public final JComponent getWindowUI() {
        return this.tabbedPane;
    }

    public final JComponent getViewAndSearchComponent() {
        return this.viewAndSearchComponent;
    }

    @Override
    public final String getTitle() {
        return null;
    }

    @Override
    public final boolean allowClose() {
        return true;
    }

    @Override
    public final Icon getIcon() {
        return ICON;
    }

    private void init(EnrichmentDb enrichmentDb) {
        this.positiveLabel = new JLabel(" ");
        this.positiveLabel.setForeground(Color.RED);
        String string = "na pos";
        String string2 = "na neg";
        if (enrichmentDb.getTemplate() != null) {
            string2 = enrichmentDb.getTemplate().getClassName(0);
            string2 = enrichmentDb.getTemplate().getClassName(1);
        }
        this.positiveLabel.setText("positive phenotype: " + string + "   ");
        this.negativeLabel = new JLabel(" ");
        this.negativeLabel.setForeground(Color.BLUE);
        this.negativeLabel.setText("negative phenotype: " + string2);
        this.phenotypePanel = new JPanel();
        this.phenotypePanel.add(this.positiveLabel);
        this.phenotypePanel.add(this.negativeLabel);
        LeadingEdgeWidget$1 leadingEdgeWidget$1 = new LeadingEdgeWidget$1(this);
        this.viewAndSearchComponent = new ViewAndSearchComponent("Run leading edge analysis", new int[]{0}, leadingEdgeWidget$1, true, this.phenotypePanel);
        JButton jButton = new JButton("Build HTML Report", GuiHelper.ICON_START16);
        jButton.addActionListener(new LeadingEdgeWidget$2(this));
        this.viewAndSearchComponent.getButtonPanel().add(jButton);
        this.viewAndSearchComponent.getTableSelectionListener().addComponent(jButton);
        this.viewAndSearchComponent.setTableModel(this.createTableModel());
        this.viewAndSearchComponent.getTable().setDefaultRenderer(String.class, new LeadingEdgeWidget$ESRenderer(this, 0, 2));
    }

    private void buildHtmlReport() {
        File file = this.edb.getEdbDir();
        if (this.runningInGenePattern) {
            if (this.htmlReportDirChooser == null) {
                this.htmlReportDirChooser = new JFileChooser();
                this.htmlReportDirChooser.setDialogTitle("Choose output directory");
                this.htmlReportDirChooser.setFileSelectionMode(1);
            }
            if (this.htmlReportDirChooser.showOpenDialog(this.tabbedPane.getTopLevelAncestor()) != 0) {
                return;
            }
            file = this.htmlReportDirChooser.getSelectedFile();
        }
        File file2 = file;
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Worker.post(new LeadingEdgeWidget$3(this, file2));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showErrorDialog(this.tabbedPane.getTopLevelAncestor(), "An error occurred while building the HTML report");
        }
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected final TableModel createTableModel() {
        return new LeadingEdgeWidget$MyTableModel(this.edb);
    }

    private void runAnalysis() {
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LeadingEdgeAnalysis leadingEdgeAnalysis = (LeadingEdgeAnalysis)Worker.post(new LeadingEdgeWidget$4(this));
            this.tabbedPane.addTab("Leading Edge Analysis-" + runs, leadingEdgeAnalysis.getComponent());
            this.tabbedPane.setSelectedComponent(leadingEdgeAnalysis.getComponent());
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showErrorDialog(this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
        }
    }

    private LeadingEdgeAnalysis runAnalysis(String[] stringArray) {
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[stringArray.length];
        GeneSet[] geneSetArray = new GeneSet[enrichmentResultArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            enrichmentResultArray[i2] = this.edb.getResultForGeneSet(stringArray[i2]);
            geneSetArray[i2] = enrichmentResultArray[i2].getSignal().getAsGeneSet();
        }
        DefaultGeneSetMatrix defaultGeneSetMatrix = new DefaultGeneSetMatrix("leading_edge_matrix_for_" + this.edb.getName(), geneSetArray);
        LeadingEdgeAnalysis leadingEdgeAnalysis = new LeadingEdgeAnalysis(defaultGeneSetMatrix, this.edb.getRankedList(), (Frame)this.tabbedPane.getTopLevelAncestor());
        leadingEdgeAnalysis.setResultDirectory(this.edb.getEdbDir());
        ++runs;
        return leadingEdgeAnalysis;
    }

    public static final void main(String[] stringArray) {
        Object object;
        Lm.verifyLicense("Broad Institute of MIT and Harvard", "Gene set  enrichment analysis java desktop application", "YSjBO6OJfF9WbavzI73Jt1HgDI4x9L21");
        OS.setLookAndFeel();
        if (stringArray.length != 1) {
            UIUtil.showMessageDialog(null, "org.genepattern.gsea.LeadingEdgeWidget.main expecting single command line argument");
            System.exit(0);
        }
        String string = stringArray[0];
        File file = null;
        try {
            file = File.createTempFile("gsea", null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while reading the input zip file");
            System.exit(0);
        }
        file.delete();
        file.mkdir();
        File file2 = file;
        Runtime.getRuntime().addShutdownHook(new LeadingEdgeWidget$5(file2));
        ZipUtility zipUtility = new ZipUtility();
        try {
            zipUtility.unzip(new File(string), file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while unzipping directory archive");
            System.exit(0);
        }
        String string2 = "Leading Edge Viewer - " + new File(string).getName();
        EnrichmentDb enrichmentDb = null;
        try {
            object = new EdbFolderParser();
            ((AbstractParser)object).setSilentMode(true);
            enrichmentDb = (EnrichmentDb)((EdbFolderParser)object).parse(file.getCanonicalPath(), (InputStream)null).get(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while reading the input file");
            System.exit(0);
        }
        object = new JFrame();
        ((Frame)object).setTitle(string2);
        ((JFrame)object).setDefaultCloseOperation(3);
        LeadingEdgeWidget leadingEdgeWidget = new LeadingEdgeWidget(enrichmentDb);
        ((JFrame)object).getContentPane().add(leadingEdgeWidget.tabbedPane);
        UIUtil.sizeToScreen((Component)object);
        ((Window)object).setVisible(true);
    }

    static final /* synthetic */ void access$000(LeadingEdgeWidget leadingEdgeWidget) {
        leadingEdgeWidget.runAnalysis();
    }

    static final /* synthetic */ void access$100(LeadingEdgeWidget leadingEdgeWidget) {
        leadingEdgeWidget.buildHtmlReport();
    }

    static final /* synthetic */ boolean access$200(LeadingEdgeWidget leadingEdgeWidget) {
        return leadingEdgeWidget.runningInGenePattern;
    }

    static final /* synthetic */ EnrichmentDb access$300(LeadingEdgeWidget leadingEdgeWidget) {
        return leadingEdgeWidget.edb;
    }

    static final /* synthetic */ ViewAndSearchComponent access$400(LeadingEdgeWidget leadingEdgeWidget) {
        return leadingEdgeWidget.viewAndSearchComponent;
    }

    static final /* synthetic */ LeadingEdgeAnalysis access$500(LeadingEdgeWidget leadingEdgeWidget, String[] stringArray) {
        return leadingEdgeWidget.runAnalysis(stringArray);
    }

    static {
        System.setProperty("org.genepattern.menu.showAccelerators", "false");
    }
}

