/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.genepattern.clustering.hierarchical.ArrayTreePanel;
import org.genepattern.clustering.hierarchical.GeneTreePanel;
import org.genepattern.clustering.hierarchical.Node;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.genepattern.gsea.HCLAlgorithm;
import org.genepattern.heatmap.HeatMapComponent;
import org.genepattern.module.AnalysisUtil;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;

public class HCLViewer {
    HCLAlgorithm alg;
    ArrayTreePanel arrayTreePanel;
    GeneTreePanel geneTreePanel;
    private IExpressionData expressionData;
    private IExpressionData reorderedData;

    public HCLViewer(IExpressionData iExpressionData, int n, int n2, int n3) {
        this.expressionData = iExpressionData;
        try {
            this.alg = new HCLAlgorithm(iExpressionData, n, n2, n3);
            this.createDisplayObjects();
        }
        catch (AlgorithmException algorithmException) {
            algorithmException.printStackTrace();
        }
    }

    private void createDisplayObjects() {
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.alg.getClusterBy() == 2 || this.alg.getClusterBy() == 1) {
            nArray = this.alg.getSamples_order();
            this.arrayTreePanel = (ArrayTreePanel)HCLViewer.createTree(this.expressionData, this.alg.getSamples_node_order(), this.alg.getSamples_child_1_array(), this.alg.getSamples_child_2_array(), this.alg.getSamples_order(), this.alg.getSamples_height().getRowPackedCopy(), true);
        }
        if (this.alg.getClusterBy() == 2 || this.alg.getClusterBy() == 0) {
            nArray2 = this.alg.getGenes_order();
            this.geneTreePanel = (GeneTreePanel)HCLViewer.createTree(this.expressionData, this.alg.getGenes_node_order(), this.alg.getGenes_child_1_array(), this.alg.getGenes_child_2_array(), this.alg.getGenes_order(), this.alg.getGenes_height().getRowPackedCopy(), false);
        }
        this.reorderedData = IExpressionDataUtil.sliceView(this.expressionData, nArray2, nArray);
    }

    public final ArrayTreePanel getArrayTreePanel() {
        return this.arrayTreePanel;
    }

    public final GeneTreePanel getGeneTreePanel() {
        return this.geneTreePanel;
    }

    public final IExpressionData getReorderedData() {
        return this.reorderedData;
    }

    public static final void main(String[] stringArray) {
        ExpressionData expressionData = AnalysisUtil.readExpressionData(stringArray[0]);
        expressionData = new ExpressionData(expressionData.getExpressionMatrix().transpose(), null, null);
        int n = 0;
        int n2 = 6;
        int n3 = 0;
        HCLViewer hCLViewer = new HCLViewer(expressionData, n, n2, n3);
        JFrame jFrame = new JFrame();
        HeatMapComponent heatMapComponent = new HeatMapComponent(jFrame, hCLViewer.getReorderedData(), hCLViewer.getGeneTreePanel(), hCLViewer.getArrayTreePanel());
        jFrame.setJMenuBar(heatMapComponent.createMenuBar(true));
        jFrame.setContentPane(heatMapComponent);
        heatMapComponent.showFrame();
    }

    private static JPanel createTree(IExpressionData iExpressionData, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, float[] fArray, boolean bl) {
        Object object;
        String string;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = bl ? iExpressionData.getColumnCount() : iExpressionData.getRowCount();
        String[] stringArray = new String[n];
        for (int i2 = 0; i2 < nArray4.length; ++i2) {
            if (bl) {
                hashMap.put(iExpressionData.getColumnName(nArray4[i2]), new Integer(i2));
                stringArray[i2] = iExpressionData.getColumnName(nArray4[i2]);
                continue;
            }
            hashMap.put(iExpressionData.getRowName(nArray4[i2]), new Integer(i2));
            stringArray[i2] = iExpressionData.getRowName(nArray4[i2]);
        }
        HashMap<Object, Node> hashMap2 = new HashMap<Object, Node>();
        Node node = null;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = -1.0;
        for (int i3 = 0; i3 < nArray.length - 1; ++i3) {
            int n2;
            String string2 = "" + nArray[i3];
            string = "" + nArray2[nArray[i3]];
            if (Integer.parseInt(string) < n) {
                String string3 = string = bl ? iExpressionData.getColumnName(Integer.parseInt(string)) : iExpressionData.getRowName(Integer.parseInt(string));
            }
            if (Integer.parseInt((String)(object = "" + nArray3[nArray[i3]])) < n) {
                object = bl ? iExpressionData.getColumnName(Integer.parseInt((String)object)) : iExpressionData.getRowName(Integer.parseInt((String)object));
            }
            Node node2 = null;
            Node node3 = null;
            if (hashMap2.containsKey(string)) {
                node2 = (Node)hashMap2.get(string);
            } else {
                node2 = new Node(string);
                node2.setCorrelation(d3);
                n2 = (Integer)hashMap.get(string);
                node2.setIndex(n2);
                node2.setMinIndex(n2);
                node2.setMaxIndex(n2);
                hashMap2.put(string, node2);
            }
            if (hashMap2.containsKey(object)) {
                node3 = (Node)hashMap2.get(object);
            } else {
                node3 = new Node((String)object);
                node3.setCorrelation(d3);
                n2 = (Integer)hashMap.get(object);
                node3.setIndex(n2);
                node3.setMinIndex(n2);
                node3.setMaxIndex(n2);
                hashMap2.put(object, node3);
            }
            double d4 = fArray[nArray[i3]];
            d2 = Math.min(d2, d4);
            node = new Node(string2, node2, node3, d4);
            node.setMinIndex(Math.min(node3.getMinIndex(), node2.getMinIndex()));
            node.setMaxIndex(Math.max(node3.getMaxIndex(), node2.getMaxIndex()));
            node2.setParent(node);
            node3.setParent(node);
            hashMap2.put(string2, node);
        }
        double d5 = node.getCorrelation();
        string = node.getId();
        if (bl) {
            object = new ArrayTreePanel(hashMap2, string, stringArray);
            ((ArrayTreePanel)object).setYMax(d5);
            ((ArrayTreePanel)object).setYMin(d2);
            ((JComponent)object).setPreferredSize(new Dimension(300, 150));
            ((ArrayTreePanel)object).setElementWidth(8);
            return object;
        }
        object = new GeneTreePanel(hashMap2, string, stringArray);
        ((GeneTreePanel)object).setXMax(d2);
        ((GeneTreePanel)object).setXMin(d5);
        ((JComponent)object).setPreferredSize(new Dimension(300, 150));
        ((GeneTreePanel)object).setElementHeight(8);
        return object;
    }
}

