/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.matrix;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.data.matrix.IClassVector;
import org.genepattern.data.matrix.IExpressionDataUtil$1;
import org.genepattern.data.matrix.IExpressionDataUtil$2;
import org.genepattern.data.matrix.IExpressionDataUtil$3;
import org.genepattern.io.Util;

public class IExpressionDataUtil {
    private IExpressionDataUtil() {
    }

    public static final Set intersection(Object[] objectArray, Object[] objectArray2) {
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(objectArray));
        HashSet<Object> hashSet2 = new HashSet<Object>(Arrays.asList(objectArray2));
        hashSet.retainAll(hashSet2);
        return hashSet;
    }

    public static final String[] getDataNames(IExpressionData iExpressionData) {
        String[] stringArray = new String[iExpressionData.getDataCount()];
        int n = iExpressionData.getDataCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iExpressionData.getDataName(i2);
        }
        return stringArray;
    }

    public static final String[] getRowMetadataNames(IExpressionData iExpressionData) {
        String[] stringArray = new String[iExpressionData.getRowMetadataCount()];
        int n = iExpressionData.getRowMetadataCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iExpressionData.getRowMetadataName(i2);
        }
        return stringArray;
    }

    public static final String[] getColumnMetadataNames(IExpressionData iExpressionData) {
        String[] stringArray = new String[iExpressionData.getColumnMetadataCount()];
        int n = iExpressionData.getColumnMetadataCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iExpressionData.getColumnMetadataName(i2);
        }
        return stringArray;
    }

    public static final String[] getColumnNames(IExpressionData iExpressionData) {
        String[] stringArray = new String[iExpressionData.getColumnCount()];
        int n = iExpressionData.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iExpressionData.getColumnName(i2);
        }
        return stringArray;
    }

    public final String[] getRowNames(IExpressionData iExpressionData) {
        String[] stringArray = new String[iExpressionData.getRowCount()];
        int n = iExpressionData.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iExpressionData.getRowName(i2);
        }
        return stringArray;
    }

    public static final IExpressionData mergeColumnsView(IExpressionData iExpressionData, IExpressionData iExpressionData2) {
        int n;
        Object object;
        int n2;
        TIntArrayList tIntArrayList = new TIntArrayList();
        TIntArrayList tIntArrayList2 = new TIntArrayList();
        int n3 = iExpressionData.getColumnCount();
        int n4 = iExpressionData2.getColumnCount();
        int n5 = iExpressionData.getRowCount();
        for (n2 = 0; n2 < n5; ++n2) {
            object = iExpressionData.getRowName(n2);
            n = iExpressionData2.getRowIndex((String)object);
            if (n == -1) continue;
            tIntArrayList.add(n2);
            tIntArrayList2.add(n);
        }
        n2 = n3 + n4;
        String[] stringArray = new String[n2];
        System.arraycopy(IExpressionDataUtil.getColumnNames(iExpressionData), 0, stringArray, 0, n3);
        System.arraycopy(IExpressionDataUtil.getColumnNames(iExpressionData2), 0, stringArray, n3, n4);
        Util.makeUnique(stringArray);
        object = new TObjectIntHashMap(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            ((TObjectIntHashMap)object).put(stringArray[n], n);
        }
        String[] stringArray2 = new HashSet(IExpressionDataUtil.intersection(IExpressionDataUtil.getDataNames(iExpressionData), IExpressionDataUtil.getDataNames(iExpressionData2))).toArray(new String[0]);
        String[] stringArray3 = new HashSet(IExpressionDataUtil.intersection(IExpressionDataUtil.getRowMetadataNames(iExpressionData), IExpressionDataUtil.getRowMetadataNames(iExpressionData2))).toArray(new String[0]);
        String[] stringArray4 = new HashSet(IExpressionDataUtil.intersection(IExpressionDataUtil.getColumnMetadataNames(iExpressionData), IExpressionDataUtil.getColumnMetadataNames(iExpressionData2))).toArray(new String[0]);
        return new IExpressionDataUtil$1(n3, iExpressionData, iExpressionData2, tIntArrayList, tIntArrayList2, n2, stringArray, (TObjectIntHashMap)object, stringArray2, stringArray3, stringArray4);
    }

    public static final IExpressionData transposeView(IExpressionData iExpressionData) {
        return new IExpressionDataUtil$2(iExpressionData);
    }

    public static final IExpressionData sliceView(IExpressionData iExpressionData, String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2 = stringArray != null ? new int[stringArray.length] : null;
        int[] nArray3 = nArray = stringArray2 != null ? new int[stringArray2.length] : null;
        if (nArray2 != null) {
            n3 = nArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = iExpressionData.getRowIndex(stringArray[n2]);
                if (n == -1) {
                    throw new IllegalArgumentException("Row name " + stringArray[n2] + " not found.");
                }
                nArray2[n2] = n;
            }
        }
        if (nArray != null) {
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = iExpressionData.getColumnIndex(stringArray2[n2]);
                if (n == -1) {
                    throw new IllegalArgumentException("Column name " + stringArray2[n2] + " not found.");
                }
                nArray[n2] = n;
            }
        }
        return IExpressionDataUtil.sliceView(iExpressionData, nArray2, nArray);
    }

    public static final IExpressionData sliceView(IExpressionData iExpressionData, int[] nArray, int[] nArray2) {
        int n;
        if (iExpressionData instanceof ExpressionData) {
            return ((ExpressionData)iExpressionData).slice(nArray, nArray2);
        }
        if (nArray == null) {
            nArray = new int[iExpressionData.getRowCount()];
            n = iExpressionData.getRowCount();
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[iExpressionData.getColumnCount()];
            n = iExpressionData.getColumnCount();
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        int[] nArray3 = nArray;
        int[] nArray4 = nArray2;
        return new IExpressionDataUtil$3(iExpressionData, nArray3, nArray4);
    }

    public static final IExpressionData createRandomData(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i2][i3] = Math.random() * 300.0 + 1.0;
            }
        }
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D(dArray);
        ExpressionData expressionData = new ExpressionData(doubleMatrix2D, null, null);
        return expressionData;
    }

    public static final String toString(IExpressionData iExpressionData) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(4);
        StringBuffer stringBuffer = new StringBuffer();
        int n = iExpressionData.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = iExpressionData.getColumnCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                stringBuffer.append(numberFormat.format(iExpressionData.getValue(i2, i3)));
                stringBuffer.append(" ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static final IClassVector slice(IClassVector iClassVector, int[] nArray) {
        String[] stringArray = new String[nArray.length];
        int n = nArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iClassVector.getClassName(iClassVector.getAssignment(nArray[i2]));
        }
        String[] stringArray2 = new String[iClassVector.getClassCount()];
        int n2 = iClassVector.getClassCount();
        for (n = 0; n < n2; ++n) {
            stringArray2[n] = iClassVector.getClassName(n);
        }
        return new ClassVector(stringArray, stringArray2);
    }

    public static final DoubleMatrix2D toMatrix(IExpressionData iExpressionData) {
        int n;
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D(iExpressionData.getRowCount(), iExpressionData.getColumnCount());
        int n2 = iExpressionData.getRowCount();
        for (n = 0; n < n2; ++n) {
            doubleMatrix2D.setRowName(n, iExpressionData.getRowName(n));
            int n3 = iExpressionData.getColumnCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                doubleMatrix2D.set(n, i2, iExpressionData.getValue(n, i2));
            }
        }
        n2 = iExpressionData.getColumnCount();
        for (n = 0; n < n2; ++n) {
            doubleMatrix2D.setColumnName(n, iExpressionData.getColumnName(n));
        }
        return doubleMatrix2D;
    }
}

