/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.matrix;

import Jama.Matrix;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import org.genepattern.data.matrix.DoubleMatrix2D$ObjectIntMap;

public class DoubleMatrix2D {
    DoubleMatrix2D$ObjectIntMap rowNameToRowIndexMap;
    DoubleMatrix2D$ObjectIntMap columnNameToColumnIndexMap;
    String[] rowNames;
    String[] columnNames;
    Matrix matrix;

    public DoubleMatrix2D(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        this.matrix = new Matrix(dArray);
        this.rowNameToRowIndexMap = new DoubleMatrix2D$ObjectIntMap(n);
        this.columnNameToColumnIndexMap = new DoubleMatrix2D$ObjectIntMap(n2);
        this.rowNames = new String[n];
        this.columnNames = new String[n2];
        this.fillInRows(0);
        this.fillInColumns(0);
    }

    public DoubleMatrix2D(double[][] dArray, String[] stringArray, String[] stringArray2) {
        int n = dArray.length;
        if (n == 0) {
            throw new IllegalArgumentException("Number of rows must be greater than 0");
        }
        int n2 = dArray[0].length;
        if (n2 == 0) {
            throw new IllegalArgumentException("Number of columns must be greater than 0");
        }
        this.matrix = new Matrix(dArray);
        this.rowNameToRowIndexMap = new DoubleMatrix2D$ObjectIntMap(n);
        this.columnNameToColumnIndexMap = new DoubleMatrix2D$ObjectIntMap(n2);
        if (stringArray2.length != n2) {
            throw new IllegalArgumentException("Length of column names must be equal to number of columns in data.");
        }
        if (stringArray.length != n) {
            throw new IllegalArgumentException("Length of row names must be equal to number of rows in data.");
        }
        this.rowNames = new String[n];
        this.columnNames = new String[n2];
        this.setRowNames(Arrays.asList(stringArray));
        this.setColumnNames(Arrays.asList(stringArray2));
    }

    public DoubleMatrix2D(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of rows must be greater than 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of columns must be greater than 0");
        }
        this.matrix = new Matrix(n, n2);
        this.rowNameToRowIndexMap = new DoubleMatrix2D$ObjectIntMap(n);
        this.columnNameToColumnIndexMap = new DoubleMatrix2D$ObjectIntMap(n2);
        this.rowNames = new String[n];
        this.columnNames = new String[n2];
        this.fillInRows(0);
        this.fillInColumns(0);
    }

    private DoubleMatrix2D() {
    }

    public final void print(PrintStream printStream, String string) {
        this.print(printStream, string, NumberFormat.getInstance());
    }

    public final void print(PrintStream printStream, String string, NumberFormat numberFormat) {
        int n;
        int n2 = this.getColumnCount();
        for (n = 0; n < n2; ++n) {
            printStream.print(string);
            printStream.print(this.columnNames[n]);
        }
        n = this.getColumnCount();
        int n3 = this.getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            printStream.println();
            printStream.print(this.rowNames[n2]);
            printStream.print(string);
            for (int i2 = 0; i2 < n - 1; ++i2) {
                printStream.print(numberFormat.format(this.matrix.get(n2, i2)));
                printStream.print(string);
            }
            printStream.print(numberFormat.format(this.matrix.get(n2, n - 1)));
        }
    }

    public final DoubleMatrix2D transpose() {
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D();
        doubleMatrix2D.rowNames = (String[])this.columnNames.clone();
        doubleMatrix2D.columnNames = (String[])this.rowNames.clone();
        doubleMatrix2D.columnNameToColumnIndexMap = (DoubleMatrix2D$ObjectIntMap)this.rowNameToRowIndexMap.clone();
        doubleMatrix2D.rowNameToRowIndexMap = (DoubleMatrix2D$ObjectIntMap)this.columnNameToColumnIndexMap.clone();
        doubleMatrix2D.matrix = this.matrix.transpose();
        return doubleMatrix2D;
    }

    public final DoubleMatrix2D slice(String[] stringArray, String[] stringArray2) {
        int n;
        int[] nArray = null;
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            n = stringArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                nArray[i2] = this.rowNameToRowIndexMap.get(stringArray[i2]);
            }
        }
        int[] nArray2 = null;
        if (stringArray2 != null) {
            nArray2 = new int[stringArray2.length];
            int n2 = stringArray2.length;
            for (n = 0; n < n2; ++n) {
                nArray2[n] = this.columnNameToColumnIndexMap.get(stringArray2[n]);
            }
        }
        return this.slice(nArray, nArray2);
    }

    public final DoubleMatrix2D slice(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.getRowCount()];
            n2 = this.getRowCount();
            while (--n2 >= 0) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.getColumnCount()];
            n2 = this.getColumnCount();
            while (--n2 >= 0) {
                nArray2[n2] = n2;
            }
        }
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D();
        doubleMatrix2D.matrix = this.matrix.getMatrix(nArray, nArray2);
        doubleMatrix2D.rowNames = new String[nArray.length];
        doubleMatrix2D.rowNameToRowIndexMap = new DoubleMatrix2D$ObjectIntMap(nArray.length);
        doubleMatrix2D.columnNames = new String[nArray2.length];
        doubleMatrix2D.columnNameToColumnIndexMap = new DoubleMatrix2D$ObjectIntMap(nArray2.length);
        int n3 = nArray.length;
        for (n = 0; n < n3; ++n) {
            doubleMatrix2D.rowNames[n] = this.rowNames[nArray[n]];
            if (doubleMatrix2D.rowNameToRowIndexMap.containsKey(doubleMatrix2D.rowNames[n])) {
                throw new IllegalArgumentException("Duplicate indices are not allowed. Row name: " + doubleMatrix2D.rowNames[n] + ", Row index: " + nArray[n]);
            }
            doubleMatrix2D.rowNameToRowIndexMap.put(doubleMatrix2D.rowNames[n], n);
        }
        n3 = nArray2.length;
        for (n = 0; n < n3; ++n) {
            doubleMatrix2D.columnNames[n] = this.columnNames[nArray2[n]];
            if (doubleMatrix2D.columnNameToColumnIndexMap.containsKey(doubleMatrix2D.columnNames[n])) {
                throw new IllegalArgumentException("Duplicate indices are not allowed. Column name: " + doubleMatrix2D.columnNames[n] + ", Column index: " + nArray2[n]);
            }
            doubleMatrix2D.columnNameToColumnIndexMap.put(doubleMatrix2D.columnNames[n], n);
        }
        return doubleMatrix2D;
    }

    public final DoubleMatrix2D times(DoubleMatrix2D doubleMatrix2D) {
        Matrix matrix = this.matrix.times(doubleMatrix2D.matrix);
        DoubleMatrix2D doubleMatrix2D2 = new DoubleMatrix2D();
        doubleMatrix2D2.matrix = matrix;
        doubleMatrix2D2.rowNames = (String[])this.rowNames.clone();
        doubleMatrix2D2.columnNames = (String[])doubleMatrix2D.columnNames.clone();
        doubleMatrix2D2.columnNameToColumnIndexMap = (DoubleMatrix2D$ObjectIntMap)doubleMatrix2D.columnNameToColumnIndexMap.clone();
        doubleMatrix2D2.rowNameToRowIndexMap = (DoubleMatrix2D$ObjectIntMap)this.rowNameToRowIndexMap.clone();
        return doubleMatrix2D2;
    }

    public final DoubleMatrix2D times(double d2) {
        Matrix matrix = this.matrix.times(d2);
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D();
        doubleMatrix2D.matrix = matrix;
        doubleMatrix2D.rowNames = (String[])this.rowNames.clone();
        doubleMatrix2D.columnNames = (String[])this.columnNames.clone();
        doubleMatrix2D.columnNameToColumnIndexMap = (DoubleMatrix2D$ObjectIntMap)this.columnNameToColumnIndexMap.clone();
        doubleMatrix2D.rowNameToRowIndexMap = (DoubleMatrix2D$ObjectIntMap)this.rowNameToRowIndexMap.clone();
        return doubleMatrix2D;
    }

    public final DoubleMatrix2D copy() {
        Matrix matrix = this.matrix.copy();
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D();
        doubleMatrix2D.matrix = matrix;
        doubleMatrix2D.rowNames = (String[])this.rowNames.clone();
        doubleMatrix2D.columnNames = (String[])this.columnNames.clone();
        doubleMatrix2D.columnNameToColumnIndexMap = (DoubleMatrix2D$ObjectIntMap)this.columnNameToColumnIndexMap.clone();
        doubleMatrix2D.rowNameToRowIndexMap = (DoubleMatrix2D$ObjectIntMap)this.rowNameToRowIndexMap.clone();
        return doubleMatrix2D;
    }

    public final DoubleMatrix2D plus(DoubleMatrix2D doubleMatrix2D) {
        DoubleMatrix2D doubleMatrix2D2 = new DoubleMatrix2D();
        doubleMatrix2D2.matrix = this.matrix.plus(doubleMatrix2D.matrix);
        doubleMatrix2D2.rowNames = (String[])this.rowNames.clone();
        doubleMatrix2D2.columnNames = (String[])this.columnNames.clone();
        doubleMatrix2D2.columnNameToColumnIndexMap = (DoubleMatrix2D$ObjectIntMap)this.columnNameToColumnIndexMap.clone();
        doubleMatrix2D2.rowNameToRowIndexMap = (DoubleMatrix2D$ObjectIntMap)this.rowNameToRowIndexMap.clone();
        return doubleMatrix2D2;
    }

    public final DoubleMatrix2D minus(DoubleMatrix2D doubleMatrix2D) {
        DoubleMatrix2D doubleMatrix2D2 = new DoubleMatrix2D();
        doubleMatrix2D2.matrix = this.matrix.minus(doubleMatrix2D.matrix);
        doubleMatrix2D2.rowNames = (String[])this.rowNames.clone();
        doubleMatrix2D2.columnNames = (String[])this.columnNames.clone();
        doubleMatrix2D2.columnNameToColumnIndexMap = (DoubleMatrix2D$ObjectIntMap)this.columnNameToColumnIndexMap.clone();
        doubleMatrix2D2.rowNameToRowIndexMap = (DoubleMatrix2D$ObjectIntMap)this.rowNameToRowIndexMap.clone();
        return doubleMatrix2D2;
    }

    public final double det() {
        return this.matrix.det();
    }

    public final int rank() {
        return this.matrix.rank();
    }

    public final double trace() {
        return this.matrix.trace();
    }

    private void fillInRows(int n) {
        int n2 = this.getRowCount();
        for (int i2 = n; i2 < n2; ++i2) {
            String string = String.valueOf(i2 + 1);
            if (this.rowNameToRowIndexMap.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate row names are not allowed:" + string);
            }
            this.rowNameToRowIndexMap.put(string, i2);
            this.rowNames[i2] = string;
        }
    }

    private void fillInColumns(int n) {
        int n2 = this.getColumnCount();
        for (int i2 = n; i2 < n2; ++i2) {
            String string = "X" + String.valueOf(i2 + 1);
            if (this.columnNameToColumnIndexMap.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate names are not allowed:" + string);
            }
            this.columnNameToColumnIndexMap.put(string, i2);
            this.columnNames[i2] = string;
        }
    }

    public final void set(int n, int n2, double d2) {
        this.matrix.set(n, n2, d2);
    }

    public final void set(String string, String string2, double d2) {
        if (!this.rowNameToRowIndexMap.containsKey(string)) {
            throw new IllegalArgumentException("row name " + string + " not found.");
        }
        if (!this.columnNameToColumnIndexMap.containsKey(string2)) {
            throw new IllegalArgumentException("column name " + string2 + " not found.");
        }
        this.matrix.set(this.rowNameToRowIndexMap.get(string), this.columnNameToColumnIndexMap.get(string2), d2);
    }

    public final void setColumnName(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null column names are not allowed.");
        }
        if (this.columnNameToColumnIndexMap.containsKey(string) && this.columnNameToColumnIndexMap.get(string) != n) {
            throw new IllegalArgumentException("Duplicate column names are not allowed:" + string);
        }
        this.columnNameToColumnIndexMap.put(string, n);
        this.columnNames[n] = string;
    }

    public final void setRowName(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null row names are not allowed.");
        }
        if (this.rowNameToRowIndexMap.containsKey(string) && this.rowNameToRowIndexMap.get(string) != n) {
            throw new IllegalArgumentException("Duplicate row names are not allowed:" + string);
        }
        this.rowNameToRowIndexMap.put(string, n);
        this.rowNames[n] = string;
    }

    private void setRowNames(List list) {
        if (list.size() > this.getRowCount()) {
            throw new IllegalArgumentException("Invalid row names length. getRowCount():" + this.getRowCount() + " row names length:" + list.size());
        }
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String string = (String)list.get(i2);
            if (this.rowNameToRowIndexMap.containsKey(string) && this.rowNameToRowIndexMap.get(string) != i2) {
                throw new IllegalArgumentException("Duplicate row names are not allowed:" + string);
            }
            if (string == null) {
                throw new IllegalArgumentException("Null row names are not allowed.");
            }
            this.rowNameToRowIndexMap.put(string, i2);
            this.rowNames[i2] = string;
        }
    }

    private void setColumnNames(List list) {
        if (list.size() > this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column names length. getColumnCount():" + this.getColumnCount() + " column names length:" + list.size());
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            if (this.columnNameToColumnIndexMap.containsKey(string) && this.columnNameToColumnIndexMap.get(string) != i2) {
                throw new IllegalArgumentException("Duplicate column names are not allowed:" + string);
            }
            if (string == null) {
                throw new IllegalArgumentException("Null column names are not allowed.");
            }
            this.columnNameToColumnIndexMap.put(string, i2);
            this.columnNames[i2] = string;
        }
    }

    public final int getRowIndex(String string) {
        if (this.rowNameToRowIndexMap.containsKey(string)) {
            return this.rowNameToRowIndexMap.get(string);
        }
        return -1;
    }

    public final int getColumnIndex(String string) {
        if (this.columnNameToColumnIndexMap.containsKey(string)) {
            return this.columnNameToColumnIndexMap.get(string);
        }
        return -1;
    }

    public final double get(int n, int n2) {
        return this.matrix.get(n, n2);
    }

    public final double[] getRow(int n) {
        return this.matrix.getArray()[n];
    }

    public final double[][] getArray() {
        return this.matrix.getArray();
    }

    public final String getRowName(int n) {
        return this.rowNames[n];
    }

    public final String getColumnName(int n) {
        return this.columnNames[n];
    }

    public final String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public final String[] getRowNames() {
        return (String[])this.rowNames.clone();
    }

    public final int getRowCount() {
        return this.matrix.getRowDimension();
    }

    public final int getColumnCount() {
        return this.matrix.getColumnDimension();
    }
}

