/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.clustering.hierarchical;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genepattern.clustering.hierarchical.AtrGtrReader;
import org.genepattern.clustering.hierarchical.GeneTreePanel$MyMouseListener;
import org.genepattern.clustering.hierarchical.Node;
import org.genepattern.clustering.hierarchical.Tree;

public class GeneTreePanel
extends JPanel
implements Scrollable,
Tree {
    protected String rootId;
    protected Map nodes;
    protected int maxIndex;
    protected int elementHeight;
    protected Color selectedColor = Color.magenta;
    protected Node selectedNode = null;
    protected String[] geneIds;
    protected int leftGutter = 4;
    protected int rightGutter = 4;
    protected double xPixPerUnit;
    protected double xmax;
    protected double xmin;
    protected EventListenerList listenerList = new EventListenerList();
    private double[] pixelMatrix = new double[6];

    public GeneTreePanel(AtrGtrReader atrGtrReader) {
        this.init(atrGtrReader.getNodes(), atrGtrReader.getRootNodeId(), atrGtrReader.getIds());
        this.xmin = atrGtrReader.getMinArrayCorr();
        this.xmax = 1.0;
    }

    public GeneTreePanel(Map map, String string, String[] stringArray) {
        this.init(map, string, stringArray);
    }

    public final void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    public final void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    protected final void notifyListeners() {
        int n = this.selectedNode != null ? this.selectedNode.getMinIndex() : -1;
        int n2 = this.selectedNode != null ? this.selectedNode.getMaxIndex() : -1;
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, false);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ListSelectionListener.class) continue;
            ((ListSelectionListener)objectArray[i2 + 1]).valueChanged(listSelectionEvent);
        }
    }

    public final void setElementHeight(int n) {
        this.elementHeight = n;
    }

    public final void setSelectedNode(Node node) {
        this.selectedNode = node;
    }

    public final Node getSelectedNode() {
        return this.selectedNode;
    }

    public final void setNodes(HashMap hashMap) {
        this.nodes = hashMap;
    }

    public final BufferedImage snapshot() {
        BufferedImage bufferedImage = new BufferedImage(this.getPreferredSize().width, this.getPreferredSize().height, 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.black);
        this.paintComponent(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.pixelMatrix[0] = this.xPixPerUnit = (double)Math.max(this.getWidth() - this.leftGutter - this.rightGutter - 1, 1) / (this.xmax - this.xmin);
        this.pixelMatrix[1] = 0.0;
        this.pixelMatrix[2] = 0.0;
        this.pixelMatrix[4] = -this.xmin * this.xPixPerUnit + (double)this.leftGutter;
        Node node = (Node)this.nodes.get(this.rootId);
        this.draw(graphics2D, node);
    }

    public final void draw(Graphics2D graphics2D, Node node) {
        Node node2 = node.getLeft();
        Node node3 = node.getRight();
        this.drawSingleNode(graphics2D, node);
        if (!node2.isLeaf()) {
            this.draw(graphics2D, node2);
        }
        if (!node3.isLeaf()) {
            this.draw(graphics2D, node3);
        }
    }

    private final int xToPix(double d2) {
        double d3 = this.pixelMatrix[0] * d2 + this.pixelMatrix[4];
        return (int)Math.floor(d3);
    }

    public final void drawSingleNode(Graphics2D graphics2D, Node node) {
        Color color = node.getColor();
        if (node.isSelected()) {
            color = this.selectedColor;
        }
        Node node2 = node.getLeft();
        Node node3 = node.getRight();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (node3 != null) {
            n = (int)(node3.getIndex() * (double)this.elementHeight + (double)this.elementHeight / 2.0);
            n3 = this.xToPix(node3.correlation);
        }
        if (node2 != null) {
            n2 = (int)(node2.getIndex() * (double)this.elementHeight + (double)this.elementHeight / 2.0);
            n4 = this.xToPix(node2.correlation);
        }
        int n5 = this.xToPix(node.correlation);
        graphics2D.setColor(color);
        graphics2D.drawPolyline(new int[]{n3, n5, n5, n4}, new int[]{n, n, n2, n2}, 4);
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.maxIndex * this.elementHeight;
        return dimension;
    }

    private void init(Map map, String string, String[] stringArray) {
        this.nodes = map;
        this.maxIndex = map.size();
        this.rootId = string;
        this.geneIds = stringArray;
        this.addMouseListener(new GeneTreePanel$MyMouseListener(this));
    }

    public final Point getNodePosition(Node node) {
        int n = this.xToPix(node.correlation);
        int n2 = (int)(node.getIndex() * (double)this.elementHeight + (double)this.elementHeight / 2.0);
        return new Point(n, n2);
    }

    @Override
    public final Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public final int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 10;
        if (n == 1) {
            n3 = 10;
        } else if (n == 0) {
            n3 = this.elementHeight * 5;
        }
        return n3;
    }

    @Override
    public final boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public final boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public final int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 10;
        if (n == 1) {
            n3 = 10;
        } else if (n == 0) {
            n3 = this.elementHeight;
        }
        return n3;
    }

    @Override
    public final void deselectSelectedNode() {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.repaint();
    }

    @Override
    public final void setSelectedNodeColor(Color color) {
        Node node = this.selectedNode;
        if (node == null) {
            node = (Node)this.nodes.get(this.rootId);
        }
        node.setRootColor(color);
    }

    public final void flip() {
        int n;
        Node node = this.selectedNode.getLeft();
        Node node2 = this.selectedNode.getRight();
        this.selectedNode.setRight(node);
        this.selectedNode.setLeft(node2);
        int n2 = this.selectedNode.getMinIndex();
        int n3 = n = this.selectedNode.getMaxIndex();
        String[] stringArray = (String[])this.geneIds.clone();
        for (int i2 = n2; i2 <= n; ++i2) {
            Node node3 = (Node)this.nodes.get(this.geneIds[i2]);
            node3.setIndex(n3);
            node3.setMaxIndex(n3);
            node3.setMinIndex(n3);
            stringArray[i2] = this.geneIds[n3];
            --n3;
        }
        this.geneIds = stringArray;
        this.selectedNode.recomputeIndices();
    }

    public final void setLeftGutter(int n) {
        this.leftGutter = n;
    }

    public final void setRightGutter(int n) {
        this.rightGutter = n;
    }

    public final void setXMax(double d2) {
        this.xmax = d2;
    }

    public final void setXMin(double d2) {
        this.xmin = d2;
    }
}

