/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.clustering.hierarchical;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genepattern.clustering.hierarchical.ArrayTreePanel$MyMouseListener;
import org.genepattern.clustering.hierarchical.AtrGtrReader;
import org.genepattern.clustering.hierarchical.Node;
import org.genepattern.clustering.hierarchical.Tree;

public class ArrayTreePanel
extends JPanel
implements Scrollable,
Tree {
    protected String[] arrayIds;
    protected int bottomGutter = 4;
    protected int elementWidth;
    protected EventListenerList listenerList = new EventListenerList();
    protected int maxIndex;
    protected Map nodes;
    protected String rootId;
    protected Color selectedColor = Color.magenta;
    protected Node selectedNode = null;
    protected boolean subtractElementWidth;
    protected int topGutter = 4;
    protected double ymax;
    protected double ymin;
    protected double yPixPerUnit;
    protected double[] pixelMatrix = new double[6];

    public ArrayTreePanel(AtrGtrReader atrGtrReader) {
        this.init(atrGtrReader.getNodes(), atrGtrReader.getRootNodeId(), atrGtrReader.getIds());
        this.ymin = 1.0;
        this.ymax = atrGtrReader.getMinArrayCorr();
    }

    public ArrayTreePanel(Map map, String string, String[] stringArray) {
        this.init(map, string, stringArray);
    }

    public final void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public final void deselectSelectedNode() {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.repaint();
    }

    public final void draw(Graphics2D graphics2D, Node node) {
        Node node2 = node.getLeft();
        Node node3 = node.getRight();
        this.drawSingleNode(graphics2D, node);
        if (!node2.isLeaf()) {
            this.draw(graphics2D, node2);
        }
        if (!node3.isLeaf()) {
            this.draw(graphics2D, node3);
        }
    }

    public final void drawSingleNode(Graphics2D graphics2D, Node node) {
        Color color = node.getColor();
        if (node.isSelected()) {
            color = this.selectedColor;
        }
        Node node2 = node.getLeft();
        Node node3 = node.getRight();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (node3 != null) {
            n = (int)(node3.getIndex() * (double)this.elementWidth + (double)this.elementWidth / 2.0);
            n3 = this.yToPix(node3.correlation);
        }
        if (node2 != null) {
            n2 = (int)(node2.getIndex() * (double)this.elementWidth + (double)this.elementWidth / 2.0);
            n4 = this.yToPix(node2.correlation);
        }
        if (this.subtractElementWidth) {
            n2 -= this.elementWidth;
            n -= this.elementWidth;
        }
        int n5 = this.yToPix(node.correlation);
        graphics2D.setColor(color);
        graphics2D.drawPolyline(new int[]{n, n, n2, n2}, new int[]{n3, n5, n5, n4}, 4);
    }

    public final void flip() {
        int n;
        Node node = this.selectedNode.getLeft();
        Node node2 = this.selectedNode.getRight();
        this.selectedNode.setRight(node);
        this.selectedNode.setLeft(node2);
        int n2 = this.selectedNode.getMinIndex();
        int n3 = n = this.selectedNode.getMaxIndex();
        String[] stringArray = (String[])this.arrayIds.clone();
        for (int i2 = n2; i2 <= n; ++i2) {
            Node node3 = (Node)this.nodes.get(this.arrayIds[i2]);
            node3.setIndex(n3);
            node3.setMaxIndex(n3);
            node3.setMinIndex(n3);
            stringArray[i2] = this.arrayIds[n3];
            --n3;
        }
        this.arrayIds = stringArray;
        this.selectedNode.recomputeIndices();
    }

    public final Point getNodePosition(Node node) {
        int n = (int)(node.getIndex() * (double)this.elementWidth + (double)this.elementWidth / 2.0);
        int n2 = this.yToPix(node.getCorrelation());
        return new Point(n, n2);
    }

    @Override
    public final Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.maxIndex * this.elementWidth;
        return dimension;
    }

    @Override
    public final int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 10;
        if (n == 1) {
            n3 = 10;
        } else if (n == 0) {
            n3 = this.elementWidth * 5;
        }
        return n3;
    }

    @Override
    public final boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public final boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public final int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 10;
        if (n == 1) {
            n3 = 10;
        } else if (n == 0) {
            n3 = this.elementWidth;
        }
        return n3;
    }

    public final Node getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public final String getToolTipText(MouseEvent mouseEvent) {
        Node node = this.getNode(mouseEvent);
        if (node != null) {
            return node.getId() + " " + node.getIndex();
        }
        return null;
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.yPixPerUnit = (double)Math.max(this.getHeight() - this.bottomGutter - this.topGutter - 1, 1) / (this.ymax - this.ymin);
        this.pixelMatrix[1] = 0.0;
        this.pixelMatrix[2] = 0.0;
        this.pixelMatrix[3] = -this.yPixPerUnit;
        this.pixelMatrix[5] = this.ymax * this.yPixPerUnit + (double)this.topGutter;
        Node node = (Node)this.nodes.get(this.rootId);
        this.draw(graphics2D, node);
    }

    public final void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    public final void setBottomGutter(int n) {
        this.bottomGutter = n;
    }

    public final void setElementWidth(int n) {
        this.elementWidth = n;
    }

    public final void setNodes(HashMap hashMap) {
        this.nodes = hashMap;
    }

    @Override
    public final void setSelectedNodeColor(Color color) {
        Node node = this.selectedNode;
        if (node == null) {
            node = (Node)this.nodes.get(this.rootId);
        }
        node.setRootColor(color);
    }

    public final void setSubtractElementWidth(boolean bl) {
        this.subtractElementWidth = bl;
    }

    public final void setTopGutter(int n) {
        this.topGutter = n;
    }

    public final void setYMax(double d2) {
        this.ymax = d2;
    }

    public final void setYMin(double d2) {
        this.ymin = d2;
    }

    public final BufferedImage snapshot() {
        BufferedImage bufferedImage = new BufferedImage(this.getPreferredSize().width, this.getPreferredSize().height, 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.black);
        this.paintComponent(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    protected final Node getNode(MouseEvent mouseEvent) {
        double d2 = mouseEvent.getX();
        double d3 = mouseEvent.getY();
        int n = (int)(d2 / (double)this.elementWidth);
        if (n < 0 || n > this.arrayIds.length) {
            return null;
        }
        String string = this.arrayIds[n];
        Node node = (Node)this.nodes.get(string);
        if (node != null) {
            while (!node.isRoot()) {
                Node node2 = node.getParent();
                Point point = this.getNodePosition(node2);
                if (Math.abs((double)point.x - d2) < 4.0 && Math.abs((double)point.y - d3) < 4.0) {
                    return node2;
                }
                node = node2;
            }
        }
        return null;
    }

    protected final void notifyListeners() {
        int n = this.selectedNode != null ? this.selectedNode.getMinIndex() : -1;
        int n2 = this.selectedNode != null ? this.selectedNode.getMaxIndex() : -1;
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, false);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ListSelectionListener.class) continue;
            ((ListSelectionListener)objectArray[i2 + 1]).valueChanged(listSelectionEvent);
        }
    }

    public final double getYPixPerUnit() {
        return -this.pixelMatrix[3];
    }

    private final int yToPix(double d2) {
        double d3 = this.pixelMatrix[3] * d2 + this.pixelMatrix[5];
        return (int)Math.floor(d3);
    }

    private void init(Map map, String string, String[] stringArray) {
        this.nodes = map;
        this.maxIndex = map.size();
        this.rootId = string;
        this.arrayIds = stringArray;
        this.addMouseListener(new ArrayTreePanel$MyMouseListener(this));
    }
}

