/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.genepattern.annotation.FeatureAnnotatorPanel$1;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.PixelConverter;
import org.genepattern.heatmap.image.FeatureAnnotator;

public class FeatureAnnotatorPanel
extends JPanel {
    private SparseClassVector classVector;
    private int widthPerClass = 6;
    private PixelConverter pixelConverter;
    private IExpressionData data;
    private int rowSize;
    private int numAnnotations = 0;

    public FeatureAnnotatorPanel(SparseClassVector sparseClassVector, IExpressionData iExpressionData, int n, JComponent jComponent) {
        this.setBackground(Color.WHITE);
        this.classVector = sparseClassVector;
        this.data = iExpressionData;
        this.rowSize = n;
        this.classVector.addListener(new FeatureAnnotatorPanel$1(this, jComponent));
        this.pixelConverter = new PixelConverter(this);
        this.pixelConverter.setRowSize(n);
    }

    public final void setRowSize(int n) {
        this.rowSize = n;
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(this.numAnnotations * this.widthPerClass + (this.numAnnotations + 1) * 2, this.data.getRowCount() * this.rowSize);
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.pixelConverter.getTopIndex(rectangle.y);
        int n2 = this.pixelConverter.getBottomIndex(rectangle.y + rectangle.height, this.data.getRowCount());
        for (int i2 = n; i2 < n2; ++i2) {
            List list = this.classVector.getClassNumbers(i2);
            if (list == null) continue;
            int n3 = 2;
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Integer n4 = (Integer)list.get(i3);
                graphics.setColor(this.classVector.getColor(n4));
                graphics.fillRect(n3, i2 * this.rowSize, this.widthPerClass, this.rowSize);
                n3 += this.widthPerClass + 2;
            }
        }
    }

    public final void setFeatureAnnotator(FeatureAnnotator featureAnnotator) {
        Serializable serializable;
        Serializable serializable2;
        HashMap<Color, Integer> hashMap = new HashMap<Color, Integer>();
        int n = 0;
        for (int i2 = 0; i2 < this.data.getRowCount(); ++i2) {
            List list = featureAnnotator.getColors(this.data.getRowName(i2));
            for (int i3 = 0; i3 < list.size(); ++i3) {
                serializable2 = (Color)list.get(i3);
                if (serializable2 == null || (serializable = (Integer)hashMap.get(serializable2)) != null) continue;
                serializable = new Integer(n++);
                hashMap.put((Color)serializable2, (Integer)serializable);
            }
        }
        SparseClassVector sparseClassVector = new SparseClassVector();
        for (Color color : hashMap.keySet()) {
            serializable2 = (Integer)hashMap.get(color);
            sparseClassVector.setClass((Integer)serializable2, "", color);
        }
        for (int i4 = 0; i4 < this.data.getRowCount(); ++i4) {
            List list = featureAnnotator.getColors(this.data.getRowName(i4));
            for (int i5 = 0; i5 < list.size(); ++i5) {
                serializable = (Color)list.get(i5);
                if (serializable == null) continue;
                sparseClassVector.addClass(i4, (Integer)hashMap.get(serializable));
            }
        }
        this.classVector = sparseClassVector;
    }

    static final /* synthetic */ int access$002(FeatureAnnotatorPanel featureAnnotatorPanel, int n) {
        featureAnnotatorPanel.numAnnotations = n;
        return featureAnnotatorPanel.numAnnotations;
    }

    static final /* synthetic */ IExpressionData access$100(FeatureAnnotatorPanel featureAnnotatorPanel) {
        return featureAnnotatorPanel.data;
    }

    static final /* synthetic */ SparseClassVector access$200(FeatureAnnotatorPanel featureAnnotatorPanel) {
        return featureAnnotatorPanel.classVector;
    }

    static final /* synthetic */ int access$000(FeatureAnnotatorPanel featureAnnotatorPanel) {
        return featureAnnotatorPanel.numAnnotations;
    }
}

