/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.tree.AbstractDocument;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.xml.sax.EntityResolver;

public class DefaultDocument
extends AbstractDocument {
    protected static final List EMPTY_LIST = Collections.EMPTY_LIST;
    protected static final Iterator EMPTY_ITERATOR = EMPTY_LIST.iterator();
    private String name;
    private Element rootElement;
    private List content;
    private DocumentType docType;
    private DocumentFactory documentFactory = DocumentFactory.getInstance();
    private transient EntityResolver entityResolver;

    public DefaultDocument() {
    }

    public DefaultDocument(String string) {
        this.name = string;
    }

    public DefaultDocument(String string, Element element, DocumentType documentType) {
        this.name = string;
        this.rootElement = element;
        this.docType = documentType;
    }

    public DefaultDocument(DocumentType documentType) {
        this.docType = documentType;
    }

    public DefaultDocument(Element element) {
        this.rootElement = element;
    }

    public DefaultDocument(Element element, DocumentType documentType) {
        this.rootElement = element;
        this.docType = documentType;
    }

    public final Document addDocType(String string, String string2, String string3) {
        this.setDocType(this.getDocumentFactory().createDocType(string, string2, string3));
        return this;
    }

    protected final void addNode(Node node) {
        if (node != null) {
            Document document = node.getDocument();
            if (document != null && document != this) {
                String string = "The Node already has an existing document: " + document;
                throw new IllegalAddException(this, node, string);
            }
            this.contentList().add(node);
            this.childAdded(node);
        }
    }

    public final void clearContent() {
        this.contentRemoved();
        this.content = null;
        this.rootElement = null;
    }

    public final Object clone() {
        DefaultDocument defaultDocument = (DefaultDocument)super.clone();
        defaultDocument.rootElement = null;
        defaultDocument.content = null;
        defaultDocument.appendContent(this);
        return defaultDocument;
    }

    protected final List contentList() {
        if (this.content == null) {
            this.content = this.createContentList();
            if (this.rootElement != null) {
                this.content.add(this.rootElement);
            }
        }
        return this.content;
    }

    public final DocumentType getDocType() {
        return this.docType;
    }

    protected final DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public final EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public final String getName() {
        return this.name;
    }

    public final Element getRootElement() {
        return this.rootElement;
    }

    public final ProcessingInstruction processingInstruction(String string) {
        List list = this.contentList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ProcessingInstruction processingInstruction;
            Object e2 = list.get(n2);
            if (e2 instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)e2).getName())) {
                return processingInstruction;
            }
            ++n2;
        }
        return null;
    }

    public final List processingInstructions() {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (e2 instanceof ProcessingInstruction) {
                backedList.add(e2);
            }
            ++n2;
        }
        return backedList;
    }

    public final List processingInstructions(String string) {
        List list = this.contentList();
        BackedList backedList = this.createResultList();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ProcessingInstruction processingInstruction;
            Object e2 = list.get(n2);
            if (e2 instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)e2).getName())) {
                backedList.add(processingInstruction);
            }
            ++n2;
        }
        return backedList;
    }

    protected final boolean removeNode(Node node) {
        if (node == this.rootElement) {
            this.rootElement = null;
        }
        if (this.contentList().remove(node)) {
            this.childRemoved(node);
            return true;
        }
        return false;
    }

    public final boolean removeProcessingInstruction(String string) {
        List list = this.contentList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction processingInstruction;
            Object e2 = iterator.next();
            if (!(e2 instanceof ProcessingInstruction) || !string.equals((processingInstruction = (ProcessingInstruction)e2).getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    protected final void rootElementAdded(Element element) {
        this.rootElement = element;
        element.setDocument(this);
    }

    public final void setContent(List list) {
        this.rootElement = null;
        this.contentRemoved();
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        if (list == null) {
            this.content = null;
        } else {
            int n = list.size();
            List list2 = this.createContentList(n);
            int n2 = 0;
            while (n2 < n) {
                Object e2 = list.get(n2);
                if (e2 instanceof Node) {
                    Node node = (Node)e2;
                    Document document = node.getDocument();
                    if (document != null && document != this) {
                        node = (Node)node.clone();
                    }
                    if (node instanceof Element) {
                        if (this.rootElement == null) {
                            this.rootElement = (Element)node;
                        } else {
                            throw new IllegalAddException("A document may only contain one Element: " + list);
                        }
                    }
                    list2.add(node);
                    this.childAdded(node);
                }
                ++n2;
            }
            this.content = list2;
        }
    }

    public final void setDocType(DocumentType documentType) {
        this.docType = documentType;
    }

    public final void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public final void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public final void setName(String string) {
        this.name = string;
    }
}

