/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.Visitor;
import org.dom4j.XPath;
import org.dom4j.rule.Pattern;

public abstract class AbstractNode
implements Node,
Cloneable,
Serializable {
    protected static final String[] NODE_TYPE_NAMES = new String[]{"Node", "Element", "Attribute", "Text", "CDATA", "Entity", "Entity", "ProcessingInstruction", "Comment", "Document", "DocumentType", "DocumentFragment", "Notation", "Namespace", "Unknown"};
    private static final DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();

    public abstract void accept(Visitor var1);

    public abstract String asXML();

    public Node asXPathResult(Element element) {
        if (this.supportsParent()) {
            return this;
        }
        return this.createXPathResult(element);
    }

    public Object clone() {
        if (this.isReadOnly()) {
            return this;
        }
        try {
            Node node = (Node)super.clone();
            node.setParent(null);
            node.setDocument(null);
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("This should never happen. Caught: " + cloneNotSupportedException);
        }
    }

    public Pattern createPattern(String string) {
        return this.getDocumentFactory().createPattern(string);
    }

    public XPath createXPath(String string) {
        return this.getDocumentFactory().createXPath(string);
    }

    public NodeFilter createXPathFilter(String string) {
        return this.getDocumentFactory().createXPathFilter(string);
    }

    protected Node createXPathResult(Element element) {
        throw new RuntimeException("asXPathResult() not yet implemented fully for: " + this);
    }

    public Node detach() {
        Element element = this.getParent();
        if (element != null) {
            element.remove(this);
        } else {
            Document document = this.getDocument();
            if (document != null) {
                document.remove(this);
            }
        }
        this.setParent(null);
        this.setDocument(null);
        return this;
    }

    public Document getDocument() {
        Element element = this.getParent();
        return element != null ? element.getDocument() : null;
    }

    protected DocumentFactory getDocumentFactory() {
        return DOCUMENT_FACTORY;
    }

    public String getName() {
        return null;
    }

    public short getNodeType() {
        return 14;
    }

    public String getNodeTypeName() {
        short s = this.getNodeType();
        if (s < 0 || s >= NODE_TYPE_NAMES.length) {
            return "Unknown";
        }
        return NODE_TYPE_NAMES[s];
    }

    public Element getParent() {
        return null;
    }

    public String getPath() {
        return this.getPath(null);
    }

    public abstract String getPath(Element var1);

    public String getStringValue() {
        return this.getText();
    }

    public String getText() {
        return null;
    }

    public String getUniquePath() {
        return this.getUniquePath(null);
    }

    public abstract String getUniquePath(Element var1);

    public boolean hasContent() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean matches(String string) {
        NodeFilter nodeFilter = this.createXPathFilter(string);
        return nodeFilter.matches(this);
    }

    public Number numberValueOf(String string) {
        XPath xPath = this.createXPath(string);
        return xPath.numberValueOf(this);
    }

    public List selectNodes(String string) {
        XPath xPath = this.createXPath(string);
        return xPath.selectNodes(this);
    }

    public List selectNodes(String string, String string2) {
        return this.selectNodes(string, string2, false);
    }

    public List selectNodes(String string, String string2, boolean bl) {
        XPath xPath = this.createXPath(string);
        XPath xPath2 = this.createXPath(string2);
        return xPath.selectNodes(this, xPath2, bl);
    }

    public Object selectObject(String string) {
        XPath xPath = this.createXPath(string);
        return xPath.selectObject(this);
    }

    public Node selectSingleNode(String string) {
        XPath xPath = this.createXPath(string);
        return xPath.selectSingleNode(this);
    }

    public void setDocument(Document document) {
    }

    public void setName(String string) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    public void setParent(Element element) {
    }

    public void setText(String string) {
        throw new UnsupportedOperationException("This node cannot be modified");
    }

    public boolean supportsParent() {
        return false;
    }

    public String valueOf(String string) {
        XPath xPath = this.createXPath(string);
        return xPath.valueOf(this);
    }

    public void write(Writer writer) {
        writer.write(this.asXML());
    }
}

