/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.DispatchHandler;

class ElementStack
implements ElementPath {
    protected Element[] stack;
    protected int lastElementIndex = -1;
    private DispatchHandler handler = null;

    public ElementStack() {
        this(50);
    }

    public ElementStack(int n) {
        this.stack = new Element[n];
    }

    public final void addHandler(String string, ElementHandler elementHandler) {
        this.handler.addHandler(this.getHandlerPath(string), elementHandler);
    }

    public final void clear() {
        this.lastElementIndex = -1;
    }

    public final Element getCurrent() {
        return this.peekElement();
    }

    public final Element getElement(int n) {
        Element element;
        try {
            element = this.stack[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            element = null;
        }
        return element;
    }

    private String getHandlerPath(String string) {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        String string2 = string.startsWith("/") ? string : (this.getPath().equals("/") ? String.valueOf(this.getPath()) + string : String.valueOf(this.getPath()) + "/" + string);
        return string2;
    }

    public final String getPath() {
        if (this.handler == null) {
            this.setDispatchHandler(new DispatchHandler());
        }
        return this.handler.getPath();
    }

    public final Element peekElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex];
    }

    public final Element popElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex--];
    }

    public final void pushElement(Element element) {
        int n = this.stack.length;
        if (++this.lastElementIndex >= n) {
            this.reallocate(n * 2);
        }
        this.stack[this.lastElementIndex] = element;
    }

    protected final void reallocate(int n) {
        Element[] elementArray = this.stack;
        this.stack = new Element[n];
        System.arraycopy(elementArray, 0, this.stack, 0, elementArray.length);
    }

    public final void removeHandler(String string) {
        this.handler.removeHandler(this.getHandlerPath(string));
    }

    public final void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.handler = dispatchHandler;
    }

    public final int size() {
        return this.lastElementIndex + 1;
    }
}

