/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.config.PropertySetterException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.OptionHandler;

public class PropertySetter {
    protected Object obj;
    protected PropertyDescriptor[] props;
    static Class class$java$lang$String;
    static Class class$org$apache$log4j$Priority;

    public PropertySetter(Object object) {
        this.obj = object;
    }

    protected final void introspect() {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.obj.getClass());
            this.props = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            LogLog.error("Failed to introspect " + this.obj + ": " + introspectionException.getMessage());
            this.props = new PropertyDescriptor[0];
        }
    }

    public static final void setProperties(Object object, Properties properties, String string) {
        new PropertySetter(object).setProperties(properties, string);
    }

    public final void setProperties(Properties properties, String string) {
        int n = string.length();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || string2.indexOf(46, n + 1) > 0) continue;
            String string3 = OptionConverter.findAndSubst(string2, properties);
            if ("layout".equals(string2 = string2.substring(n)) && this.obj instanceof Appender) continue;
            this.setProperty(string2, string3);
        }
        this.activate();
    }

    public final void setProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string = Introspector.decapitalize(string));
        if (propertyDescriptor == null) {
            LogLog.warn("No such property [" + string + "] in " + this.obj.getClass().getName() + ".");
        } else {
            try {
                this.setProperty(propertyDescriptor, string, string2);
            }
            catch (PropertySetterException propertySetterException) {
                LogLog.warn("Failed to set property [" + string + "] to value \"" + string2 + "\". ", propertySetterException.rootCause);
            }
        }
    }

    public final void setProperty(PropertyDescriptor propertyDescriptor, String string, String string2) {
        Object object;
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new PropertySetterException("No setter for property [" + string + "].");
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            object = this.convertArg(string2, classArray[0]);
        }
        catch (Throwable throwable) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed. Reason: " + throwable);
        }
        if (object == null) {
            throw new PropertySetterException("Conversion to type [" + classArray[0] + "] failed.");
        }
        LogLog.debug("Setting property [" + string + "] to [" + object + "].");
        try {
            method.invoke(this.obj, object);
        }
        catch (Exception exception) {
            throw new PropertySetterException(exception);
        }
    }

    protected final Object convertArg(String string, Class clazz) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ((class$java$lang$String == null ? (class$java$lang$String = PropertySetter.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
            return string;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return new Integer(string2);
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return new Long(string2);
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("true".equalsIgnoreCase(string2)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string2)) {
                return Boolean.FALSE;
            }
        } else if ((class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = PropertySetter.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority).isAssignableFrom(clazz)) {
            return OptionConverter.toLevel(string2, Level.DEBUG);
        }
        return null;
    }

    protected final PropertyDescriptor getPropertyDescriptor(String string) {
        if (this.props == null) {
            this.introspect();
        }
        for (int i2 = 0; i2 < this.props.length; ++i2) {
            if (!string.equals(this.props[i2].getName())) continue;
            return this.props[i2];
        }
        return null;
    }

    public final void activate() {
        if (this.obj instanceof OptionHandler) {
            ((OptionHandler)this.obj).activateOptions();
        }
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

