/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.util.Enumeration;
import org.apache.ecs.Attributes;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.GenericElement;

public abstract class ElementAttributes
extends GenericElement
implements Attributes {
    private Filter attribute_filter = this.getFilter();
    private boolean filter_attribute_state = ECSDefaults.getDefaultFilterAttributeState();
    private char attribute_equality_sign = ECSDefaults.getDefaultAttributeEqualitySign();
    private char attribute_quote_char = ECSDefaults.getDefaultAttributeQuoteChar();
    private boolean attribute_quote = ECSDefaults.getDefaultAttributeQuote();

    public Element addAttribute(String string, int n) {
        this.getElementHashEntry().put(string, new Integer(n));
        return this;
    }

    public Element addAttribute(String string, Integer n) {
        this.getElementHashEntry().put(string, n);
        return this;
    }

    public Element addAttribute(String string, Object object) {
        this.getElementHashEntry().put(string, object);
        return this;
    }

    public Element addAttribute(String string, String string2) {
        this.getElementHashEntry().put(string, string2);
        return this;
    }

    public final Enumeration attributes() {
        return this.getElementHashEntry().keys();
    }

    public String createStartTag() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartTagChar());
        if (this.getBeginStartModifierDefined()) {
            stringBuffer.append(this.getBeginStartModifier());
        }
        stringBuffer.append(this.getElementType());
        Enumeration enumeration = this.getElementHashEntry().keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (this.getAttributeFilterState()) {
                string = this.getAttributeFilter().process(this.getElementHashEntry().get(string2).toString());
            } else {
                Object v = this.getElementHashEntry().get(string2);
                if (v == null) {
                    return null;
                }
                string = v.toString();
            }
            stringBuffer.append(' ');
            stringBuffer.append(this.alterCase(string2));
            int n3 = stringBuffer.length();
            if (string.equalsIgnoreCase("ECS_NO_ATTRIBUTE_VALUE")) continue;
            boolean bl = this.attribute_quote;
            int n4 = 0;
            int n5 = 0;
            if (string.length() == 0) {
                bl = true;
            }
            int n6 = 0;
            while (n6 < string.length()) {
                n2 = string.charAt(n6);
                if (!(n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 58 || n2 == 45 || n2 == 95 || n2 == 46)) {
                    if (n2 == 39) {
                        ++n4;
                    }
                    if (n2 == 34) {
                        ++n5;
                    }
                    bl = true;
                }
                ++n6;
            }
            stringBuffer.append(this.getAttributeEqualitySign());
            if (!bl) {
                stringBuffer.append(string);
                continue;
            }
            if (n4 == 0) {
                stringBuffer.append('\'');
                stringBuffer.append(string);
                stringBuffer.append('\'');
                continue;
            }
            if (n5 == 0) {
                stringBuffer.append('\"');
                stringBuffer.append(string);
                stringBuffer.append('\"');
                continue;
            }
            if (n4 <= n5) {
                stringBuffer.append('\'');
                n2 = stringBuffer.length();
                stringBuffer.append(string);
                n = n2;
                while (n < stringBuffer.length()) {
                    if (stringBuffer.charAt(n) == '\'') {
                        stringBuffer.setCharAt(n, '&');
                        stringBuffer.insert(n + 1, "#39;");
                        ++n;
                    }
                    ++n;
                }
                stringBuffer.append('\'');
                continue;
            }
            stringBuffer.append('\"');
            n2 = stringBuffer.length();
            stringBuffer.append(string);
            n = n2;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '\"') {
                    stringBuffer.setCharAt(n, '&');
                    stringBuffer.insert(n + 1, "#34;");
                    ++n;
                }
                ++n;
            }
            stringBuffer.append('\"');
        }
        if (this.getBeginEndModifierDefined()) {
            stringBuffer.append(this.getBeginEndModifier());
        }
        stringBuffer.append(this.getEndTagChar());
        return stringBuffer.toString();
    }

    public final String getAttribute(String string) {
        return (String)this.getElementHashEntry().get(string);
    }

    public char getAttributeEqualitySign() {
        return this.attribute_equality_sign;
    }

    public Filter getAttributeFilter() {
        return this.attribute_filter;
    }

    public final boolean getAttributeFilterState() {
        return this.filter_attribute_state;
    }

    public boolean getAttributeQuote() {
        return this.attribute_quote;
    }

    public char getAttributeQuoteChar() {
        return this.attribute_quote_char;
    }

    public boolean hasAttribute(String string) {
        return this.getElementHashEntry().containsKey(string);
    }

    public Element removeAttribute(String string) {
        try {
            this.getElementHashEntry().remove(string);
        }
        catch (Exception exception) {}
        return this;
    }

    public Element setAttributeEqualitySign(char c2) {
        this.attribute_equality_sign = c2;
        return this;
    }

    public Element setAttributeFilter(Filter filter) {
        this.filter_attribute_state = true;
        this.attribute_filter = filter;
        return this;
    }

    public Element setAttributeFilterState(boolean bl) {
        this.filter_attribute_state = bl;
        return this;
    }

    public Element setAttributeQuote(boolean bl) {
        this.attribute_quote = bl;
        return this;
    }

    public Element setAttributeQuoteChar(char c2) {
        this.attribute_quote_char = c2;
        return this;
    }

    public final Element setClass(String string) {
        this.addAttribute("class", string);
        return this;
    }

    public final Element setDir(String string) {
        this.addAttribute("dir", string);
        return this;
    }

    public final Element setID(String string) {
        this.addAttribute("id", string);
        return this;
    }

    public final Element setLang(String string) {
        this.addAttribute("lang", string);
        return this;
    }

    public final Element setStyle(String string) {
        this.addAttribute("style", string);
        return this;
    }

    public final Element setTitle(String string) {
        this.addAttribute("title", string);
        return this;
    }
}

