/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Arrays;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;

    private MathUtils() {
    }

    public static final int hash(double d2) {
        return new Double(d2).hashCode();
    }

    public static final int hash(double[] dArray) {
        return Arrays.hashCode(dArray);
    }

    public static final double normalizeAngle(double d2, double d3) {
        return d2 - Math.PI * 2 * FastMath.floor((d2 + Math.PI - d3) / (Math.PI * 2));
    }

    public static final double reduce(double d2, double d3, double d4) {
        double d5 = FastMath.abs(d3);
        return d2 - d5 * FastMath.floor((d2 - d4) / d5) - d4;
    }

    public static final byte copySign(byte by, byte by2) {
        if (by >= 0 && by2 >= 0 || by < 0 && by2 < 0) {
            return by;
        }
        if (by2 >= 0 && by == -128) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -by;
    }

    public static final short copySign(short s, short s2) {
        if (s >= 0 && s2 >= 0 || s < 0 && s2 < 0) {
            return s;
        }
        if (s2 >= 0 && s == Short.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -s;
    }

    public static final int copySign(int n, int n2) {
        if (n >= 0 && n2 >= 0 || n < 0 && n2 < 0) {
            return n;
        }
        if (n2 >= 0 && n == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -n;
    }

    public static final long copySign(long l2, long l3) {
        if (l2 >= 0L && l3 >= 0L || l2 < 0L && l3 < 0L) {
            return l2;
        }
        if (l3 >= 0L && l2 == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -l2;
    }

    public static final void checkFinite(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new NotFiniteNumberException(d2, new Object[0]);
        }
    }

    public static final void checkFinite(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = dArray[i2];
            if (!Double.isInfinite(d2) && !Double.isNaN(d2)) continue;
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, d2, i2);
        }
    }

    public static final void checkNotNull(Object object, Localizable localizable, Object ... objectArray) {
        if (object == null) {
            throw new NullArgumentException(localizable, objectArray);
        }
    }

    public static final void checkNotNull(Object object) {
        if (object == null) {
            throw new NullArgumentException();
        }
    }
}

