/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public class RandomDataGenerator
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataGenerator() {
    }

    public RandomDataGenerator(RandomGenerator randomGenerator) {
        this.rand = randomGenerator;
    }

    public String nextHexString(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
        }
        RandomGenerator randomGenerator = this.getRandomGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[n / 2 + 1];
        randomGenerator.nextBytes(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            Integer n2 = byArray[i2];
            String string = Integer.toHexString(n2 + 128);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().substring(0, n);
    }

    public int nextInt(int n, int n2) {
        if (n >= n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)n, n2, false);
        }
        int n3 = n2 - n + 1;
        if (n3 <= 0) {
            int n4;
            RandomGenerator randomGenerator = this.getRandomGenerator();
            while ((n4 = randomGenerator.nextInt()) < n || n4 > n2) {
            }
            return n4;
        }
        return n + this.getRandomGenerator().nextInt(n3);
    }

    public long nextLong(long l2, long l3) {
        if (l2 >= l3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l2, l3, false);
        }
        long l4 = l3 - l2 + 1L;
        if (l4 <= 0L) {
            long l5;
            RandomGenerator randomGenerator = this.getRandomGenerator();
            while ((l5 = randomGenerator.nextLong()) < l2 || l5 > l3) {
            }
            return l5;
        }
        if (l4 < Integer.MAX_VALUE) {
            return l2 + (long)this.getRandomGenerator().nextInt((int)l4);
        }
        return l2 + RandomDataGenerator.nextLong(this.getRandomGenerator(), l4);
    }

    private static long nextLong(RandomGenerator randomGenerator, long l2) {
        if (l2 > 0L) {
            long l3;
            long l4;
            byte[] byArray = new byte[8];
            do {
                randomGenerator.nextBytes(byArray);
                l3 = 0L;
                for (byte by : byArray) {
                    l3 = l3 << 8 | (long)by & 0xFFL;
                }
            } while ((l3 &= Long.MAX_VALUE) - (l4 = l3 % l2) + (l2 - 1L) < 0L);
            return l4;
        }
        throw new NotStrictlyPositiveException(l2);
    }

    public String nextSecureHexString(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
        }
        SecureRandom secureRandom = this.getSecRan();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MathInternalError(noSuchAlgorithmException);
        }
        messageDigest.reset();
        int n2 = n / 40 + 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 1; i2 < n2 + 1; ++i2) {
            byte[] byArray = new byte[40];
            secureRandom.nextBytes(byArray);
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                Integer n3 = byArray2[i3];
                String string = Integer.toHexString(n3 + 128);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString().substring(0, n);
    }

    public int nextSecureInt(int n, int n2) {
        if (n >= n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)n, n2, false);
        }
        int n3 = n2 - n + 1;
        if (n3 <= 0) {
            int n4;
            SecureRandom secureRandom = this.getSecRan();
            while ((n4 = secureRandom.nextInt()) < n || n4 > n2) {
            }
            return n4;
        }
        return n + this.getSecRan().nextInt(n3);
    }

    public long nextSecureLong(long l2, long l3) {
        if (l2 >= l3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l2, l3, false);
        }
        long l4 = l3 - l2 + 1L;
        if (l4 <= 0L) {
            long l5;
            SecureRandom secureRandom = this.getSecRan();
            while ((l5 = secureRandom.nextLong()) < l2 || l5 > l3) {
            }
            return l5;
        }
        if (l4 < Integer.MAX_VALUE) {
            return l2 + (long)this.getSecRan().nextInt((int)l4);
        }
        return l2 + RandomDataGenerator.nextLong(this.getSecRan(), l4);
    }

    private static long nextLong(SecureRandom secureRandom, long l2) {
        if (l2 > 0L) {
            long l3;
            long l4;
            byte[] byArray = new byte[8];
            do {
                secureRandom.nextBytes(byArray);
                l3 = 0L;
                for (byte by : byArray) {
                    l3 = l3 << 8 | (long)by & 0xFFL;
                }
            } while ((l3 &= Long.MAX_VALUE) - (l4 = l3 % l2) + (l2 - 1L) < 0L);
            return l4;
        }
        throw new NotStrictlyPositiveException(l2);
    }

    public long nextPoisson(double d2) {
        return new PoissonDistribution(this.getRandomGenerator(), d2, 1.0E-12, 10000000).sample();
    }

    public double nextGaussian(double d2, double d3) {
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, d3);
        }
        return d3 * this.getRandomGenerator().nextGaussian() + d2;
    }

    public double nextExponential(double d2) {
        return new ExponentialDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextGamma(double d2, double d3) {
        return new GammaDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextHypergeometric(int n, int n2, int n3) {
        return new HypergeometricDistribution(this.getRandomGenerator(), n, n2, n3).sample();
    }

    public int nextPascal(int n, double d2) {
        return new PascalDistribution(this.getRandomGenerator(), n, d2).sample();
    }

    public double nextT(double d2) {
        return new TDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextWeibull(double d2, double d3) {
        return new WeibullDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextZipf(int n, double d2) {
        return new ZipfDistribution(this.getRandomGenerator(), n, d2).sample();
    }

    public double nextBeta(double d2, double d3) {
        return new BetaDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextBinomial(int n, double d2) {
        return new BinomialDistribution(this.getRandomGenerator(), n, d2).sample();
    }

    public double nextCauchy(double d2, double d3) {
        return new CauchyDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public double nextChiSquare(double d2) {
        return new ChiSquaredDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextF(double d2, double d3) {
        return new FDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public double nextUniform(double d2, double d3) {
        return this.nextUniform(d2, d3, false);
    }

    public double nextUniform(double d2, double d3, boolean bl) {
        if (d2 >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d2, d3, false);
        }
        if (Double.isInfinite(d2)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d2, new Object[0]);
        }
        if (Double.isInfinite(d3)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d3, new Object[0]);
        }
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new NotANumberException();
        }
        RandomGenerator randomGenerator = this.getRandomGenerator();
        double d4 = randomGenerator.nextDouble();
        while (!bl && d4 <= 0.0) {
            d4 = randomGenerator.nextDouble();
        }
        return d4 * d3 + (1.0 - d4) * d2;
    }

    public int[] nextPermutation(int n, int n2) {
        if (n2 > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)n2, n, true);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, n2);
        }
        int[] nArray = this.getNatural(n);
        this.shuffle(nArray, n - n2);
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray2[i2] = nArray[n - i2 - 1];
        }
        return nArray2;
    }

    public Object[] nextSample(Collection collection, int n) {
        int n2 = collection.size();
        if (n > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)n, n2, true);
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        Object[] objectArray = collection.toArray();
        int[] nArray = this.nextPermutation(n2, n);
        Object[] objectArray2 = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            objectArray2[i2] = objectArray[nArray[i2]];
        }
        return objectArray2;
    }

    public void reSeed(long l2) {
        this.getRandomGenerator().setSeed(l2);
    }

    public void reSeedSecure() {
        this.getSecRan().setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long l2) {
        this.getSecRan().setSeed(l2);
    }

    public void reSeed() {
        this.getRandomGenerator().setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public void setSecureAlgorithm(String string, String string2) {
        this.secRand = SecureRandom.getInstance(string, string2);
    }

    public RandomGenerator getRandomGenerator() {
        if (this.rand == null) {
            this.initRan();
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
        }
        return this.secRand;
    }

    private void shuffle(int[] nArray, int n) {
        int n2 = 0;
        for (int i2 = nArray.length - 1; i2 >= n; --i2) {
            n2 = i2 == 0 ? 0 : this.nextInt(0, i2);
            int n3 = nArray[n2];
            nArray[n2] = nArray[i2];
            nArray[i2] = n3;
        }
    }

    private int[] getNatural(int n) {
        int[] nArray = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }
}

