/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class BitsStreamGenerator
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 20130104L;
    private double nextGaussian = Double.NaN;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public void nextBytes(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length - 3;
        for (n2 = 0; n2 < n3; n2 += 4) {
            n = this.next(32);
            byArray[n2] = (byte)(n & 0xFF);
            byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
            byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
            byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
        }
        n = this.next(32);
        while (n2 < byArray.length) {
            byArray[n2++] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public double nextDouble() {
        long l2 = (long)this.next(26) << 26;
        int n = this.next(26);
        return (double)(l2 | (long)n) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double d2;
        if (Double.isNaN(this.nextGaussian)) {
            double d3 = this.nextDouble();
            double d4 = this.nextDouble();
            double d5 = Math.PI * 2 * d3;
            double d6 = FastMath.sqrt(-2.0 * FastMath.log(d4));
            d2 = d6 * FastMath.cos(d5);
            this.nextGaussian = d6 * FastMath.sin(d5);
        } else {
            d2 = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return d2;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        if (n > 0) {
            int n2;
            int n3;
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
            }
            return n2;
        }
        throw new NotStrictlyPositiveException(n);
    }

    public long nextLong() {
        long l2 = (long)this.next(32) << 32;
        long l3 = (long)this.next(32) & 0xFFFFFFFFL;
        return l2 | l3;
    }

    public long nextLong(long l2) {
        if (l2 > 0L) {
            long l3;
            long l4;
            do {
                l3 = (long)this.next(31) << 32;
            } while ((l3 |= (long)this.next(32) & 0xFFFFFFFFL) - (l4 = l3 % l2) + (l2 - 1L) < 0L);
            return l4;
        }
        throw new NotStrictlyPositiveException(l2);
    }

    public void clear() {
        this.nextGaussian = Double.NaN;
    }
}

