/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class WeibullDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private final double shape;
    private final double scale;
    private final double solverAbsoluteAccuracy;
    private double numericalMean = Double.NaN;
    private boolean numericalMeanIsCalculated = false;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;

    public WeibullDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public WeibullDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public WeibullDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d3);
        }
        this.scale = d3;
        this.shape = d2;
        this.solverAbsoluteAccuracy = d4;
    }

    public final double getShape() {
        return this.shape;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double density(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        double d3 = d2 / this.scale;
        double d4 = FastMath.pow(d3, this.shape - 1.0);
        double d5 = d4 * d3;
        return this.shape / this.scale * d4 * FastMath.exp(-d5);
    }

    public final double cumulativeProbability(double d2) {
        double d3 = d2 <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-FastMath.pow(d2 / this.scale, this.shape));
        return d3;
    }

    public final double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0.0, 1.0);
        }
        double d3 = d2 == 0.0 ? 0.0 : (d2 == 1.0 ? Double.POSITIVE_INFINITY : this.scale * FastMath.pow(-FastMath.log(1.0 - d2), 1.0 / this.shape));
        return d3;
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        if (!this.numericalMeanIsCalculated) {
            this.numericalMean = this.calculateNumericalMean();
            this.numericalMeanIsCalculated = true;
        }
        return this.numericalMean;
    }

    protected final double calculateNumericalMean() {
        double d2 = this.getShape();
        double d3 = this.getScale();
        return d3 * FastMath.exp(Gamma.logGamma(1.0 + 1.0 / d2));
    }

    public final double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected final double calculateNumericalVariance() {
        double d2 = this.getShape();
        double d3 = this.getScale();
        double d4 = this.getNumericalMean();
        return d3 * d3 * FastMath.exp(Gamma.logGamma(1.0 + 2.0 / d2)) - d4 * d4;
    }

    public final double getSupportLowerBound() {
        return 0.0;
    }

    public final double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

