/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.SaddlePointExpansion;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.util.FastMath;

public class BinomialDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int n, double d2) {
        this(new Well19937c(), n, d2);
    }

    public BinomialDistribution(RandomGenerator randomGenerator, int n, double d2) {
        super(randomGenerator);
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, n);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        this.probabilityOfSuccess = d2;
        this.numberOfTrials = n;
    }

    public final int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public final double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public final double probability(int n) {
        double d2 = n < 0 || n > this.numberOfTrials ? 0.0 : FastMath.exp(SaddlePointExpansion.logBinomialProbability(n, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
        return d2;
    }

    public final double cumulativeProbability(int n) {
        double d2 = n < 0 ? 0.0 : (n >= this.numberOfTrials ? 1.0 : 1.0 - Beta.regularizedBeta(this.probabilityOfSuccess, (double)n + 1.0, this.numberOfTrials - n));
        return d2;
    }

    public final double getNumericalMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    public final double getNumericalVariance() {
        double d2 = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * d2 * (1.0 - d2);
    }

    public final int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    public final int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

