/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public class UnivariateSolverUtils {
    private UnivariateSolverUtils() {
    }

    public static final double solve(UnivariateFunction univariateFunction, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        BrentSolver brentSolver = new BrentSolver();
        return brentSolver.solve(Integer.MAX_VALUE, univariateFunction, d2, d3);
    }

    public static final double solve(UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        BrentSolver brentSolver = new BrentSolver(d4);
        return brentSolver.solve(Integer.MAX_VALUE, univariateFunction, d2, d3);
    }

    public static final double forceSide(int n, UnivariateFunction univariateFunction, BracketedUnivariateSolver bracketedUnivariateSolver, double d2, double d3, double d4, AllowedSolution allowedSolution) {
        if (allowedSolution == AllowedSolution.ANY_SIDE) {
            return d2;
        }
        double d5 = FastMath.max(bracketedUnivariateSolver.getAbsoluteAccuracy(), FastMath.abs(d2 * bracketedUnivariateSolver.getRelativeAccuracy()));
        double d6 = FastMath.max(d3, d2 - d5);
        double d7 = univariateFunction.value(d6);
        double d8 = FastMath.min(d4, d2 + d5);
        double d9 = univariateFunction.value(d8);
        int n2 = n - 2;
        while (n2 > 0) {
            if (d7 >= 0.0 && d9 <= 0.0 || d7 <= 0.0 && d9 >= 0.0) {
                return bracketedUnivariateSolver.solve(n2, univariateFunction, d6, d8, d2, allowedSolution);
            }
            boolean bl = false;
            boolean bl2 = false;
            if (d7 < d9) {
                if (d7 >= 0.0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            } else if (d7 > d9) {
                if (d7 <= 0.0) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            } else {
                bl = true;
                bl2 = true;
            }
            if (bl) {
                d6 = FastMath.max(d3, d6 - d5);
                d7 = univariateFunction.value(d6);
                --n2;
            }
            if (!bl2) continue;
            d8 = FastMath.min(d4, d8 + d5);
            d9 = univariateFunction.value(d8);
            --n2;
        }
        throw new NoBracketingException((Localizable)LocalizedFormats.FAILED_BRACKETING, d6, d8, d7, d9, new Object[]{n - n2, n, d2, d3, d4});
    }

    public static final double[] bracket(UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        return UnivariateSolverUtils.bracket(univariateFunction, d2, d3, d4, Integer.MAX_VALUE);
    }

    public static final double[] bracket(UnivariateFunction univariateFunction, double d2, double d3, double d4, int n) {
        double d5;
        double d6;
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.INVALID_MAX_ITERATIONS, n);
        }
        UnivariateSolverUtils.verifySequence(d3, d2, d4);
        double d7 = d2;
        double d8 = d2;
        int n2 = 0;
        do {
            d7 = FastMath.max(d7 - 1.0, d3);
            d8 = FastMath.min(d8 + 1.0, d4);
        } while ((d6 = univariateFunction.value(d7)) * (d5 = univariateFunction.value(d8)) > 0.0 && ++n2 < n && (d7 > d3 || d8 < d4));
        if (d6 * d5 > 0.0) {
            throw new NoBracketingException((Localizable)LocalizedFormats.FAILED_BRACKETING, d7, d8, d6, d5, new Object[]{n2, n, d2, d3, d4});
        }
        return new double[]{d7, d8};
    }

    public static final double midpoint(double d2, double d3) {
        return (d2 + d3) * 0.5;
    }

    public static final boolean isBracketing(UnivariateFunction univariateFunction, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        double d4 = univariateFunction.value(d2);
        double d5 = univariateFunction.value(d3);
        return d4 >= 0.0 && d5 <= 0.0 || d4 <= 0.0 && d5 >= 0.0;
    }

    public static final boolean isSequence(double d2, double d3, double d4) {
        return d2 < d3 && d3 < d4;
    }

    public static final void verifyInterval(double d2, double d3) {
        if (d2 >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)d2, d3, false);
        }
    }

    public static final void verifySequence(double d2, double d3, double d4) {
        UnivariateSolverUtils.verifyInterval(d2, d3);
        UnivariateSolverUtils.verifyInterval(d3, d4);
    }

    public static final void verifyBracketing(UnivariateFunction univariateFunction, double d2, double d3) {
        if (univariateFunction == null) {
            throw new NullArgumentException(LocalizedFormats.FUNCTION, new Object[0]);
        }
        UnivariateSolverUtils.verifyInterval(d2, d3);
        if (!UnivariateSolverUtils.isBracketing(univariateFunction, d2, d3)) {
            throw new NoBracketingException(d2, d3, univariateFunction.value(d2), univariateFunction.value(d3));
        }
    }
}

