/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BaseUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.MathUtils;

public abstract class BaseAbstractUnivariateSolver
implements BaseUnivariateSolver {
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-14;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 1.0E-15;
    private final double functionValueAccuracy;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private final Incrementor evaluations = new Incrementor();
    private double searchMin;
    private double searchMax;
    private double searchStart;
    private UnivariateFunction function;

    protected BaseAbstractUnivariateSolver(double d2) {
        this(1.0E-14, d2, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d2, double d3) {
        this(d2, d3, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d2, double d3, double d4) {
        this.absoluteAccuracy = d3;
        this.relativeAccuracy = d2;
        this.functionValueAccuracy = d4;
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public final double getMin() {
        return this.searchMin;
    }

    public final double getMax() {
        return this.searchMax;
    }

    public final double getStartValue() {
        return this.searchStart;
    }

    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    protected final double computeObjectiveValue(double d2) {
        this.incrementEvaluationCount();
        return this.function.value(d2);
    }

    protected final void setup(int n, UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        MathUtils.checkNotNull(univariateFunction);
        this.searchMin = d2;
        this.searchMax = d3;
        this.searchStart = d4;
        this.function = univariateFunction;
        this.evaluations.setMaximalCount(n);
        this.evaluations.resetCount();
    }

    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3, double d4) {
        this.setup(n, univariateFunction, d2, d3, d4);
        return this.doSolve();
    }

    public double solve(int n, UnivariateFunction univariateFunction, double d2, double d3) {
        return this.solve(n, univariateFunction, d2, d3, d2 + 0.5 * (d3 - d2));
    }

    public double solve(int n, UnivariateFunction univariateFunction, double d2) {
        return this.solve(n, univariateFunction, Double.NaN, Double.NaN, d2);
    }

    protected abstract double doSolve();

    protected final boolean isBracketing(double d2, double d3) {
        return UnivariateSolverUtils.isBracketing(this.function, d2, d3);
    }

    protected final boolean isSequence(double d2, double d3, double d4) {
        return UnivariateSolverUtils.isSequence(d2, d3, d4);
    }

    protected final void verifyInterval(double d2, double d3) {
        UnivariateSolverUtils.verifyInterval(d2, d3);
    }

    protected final void verifySequence(double d2, double d3, double d4) {
        UnivariateSolverUtils.verifySequence(d2, d3, d4);
    }

    protected final void verifyBracketing(double d2, double d3) {
        UnivariateSolverUtils.verifyBracketing(this.function, d2, d3);
    }

    protected final void incrementEvaluationCount() {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
    }
}

