/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;

public class IOUtils {
    private static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static char[] SKIP_CHAR_BUFFER;
    private static byte[] SKIP_BYTE_BUFFER;

    public static final void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public static final void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    public static final void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static final void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    public static final void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    public static final void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void closeQuietly(Selector selector) {
        if (selector != null) {
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static final BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static final byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] toByteArray(InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l2);
        }
        return IOUtils.toByteArray(inputStream, (int)l2);
    }

    public static final byte[] toByteArray(InputStream inputStream, int n) {
        int n2;
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n);
        }
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 != n) {
            throw new IOException("Unexpected readed size. current: " + n2 + ", excepted: " + n);
        }
        return byArray;
    }

    public static final byte[] toByteArray(Reader reader) {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static final byte[] toByteArray(Reader reader, Charset charset) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream, charset);
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] toByteArray(Reader reader, String string) {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    public static final byte[] toByteArray(String string) {
        return string.getBytes();
    }

    public static final byte[] toByteArray(URI uRI) {
        return IOUtils.toByteArray(uRI.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] toByteArray(URL uRL) {
        URLConnection uRLConnection = uRL.openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray(uRLConnection);
            return byArray;
        }
        finally {
            IOUtils.close(uRLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] toByteArray(URLConnection uRLConnection) {
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public static final char[] toCharArray(InputStream inputStream) {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static final char[] toCharArray(InputStream inputStream, Charset charset) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static final char[] toCharArray(InputStream inputStream, String string) {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static final char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static final String toString(InputStream inputStream) {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static final String toString(InputStream inputStream, Charset charset) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        IOUtils.copy(inputStream, (Writer)stringBuilderWriter, charset);
        return stringBuilderWriter.toString();
    }

    public static final String toString(InputStream inputStream, String string) {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static final String toString(Reader reader) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        IOUtils.copy(reader, (Writer)stringBuilderWriter);
        return stringBuilderWriter.toString();
    }

    public static final String toString(URI uRI) {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static final String toString(URI uRI, Charset charset) {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static final String toString(URI uRI, String string) {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    public static final String toString(URL uRL) {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toString(URL uRL, Charset charset) {
        InputStream inputStream = uRL.openStream();
        try {
            String string = IOUtils.toString(inputStream, charset);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static final String toString(URL uRL, String string) {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    public static final String toString(byte[] byArray) {
        return new String(byArray);
    }

    public static final String toString(byte[] byArray, String string) {
        return new String(byArray, Charsets.toCharset(string));
    }

    public static final List readLines(InputStream inputStream) {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static final List readLines(InputStream inputStream, Charset charset) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.toCharset(charset));
        return IOUtils.readLines(inputStreamReader);
    }

    public static final List readLines(InputStream inputStream, String string) {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static final List readLines(Reader reader) {
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static final LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static final LineIterator lineIterator(InputStream inputStream, Charset charset) {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static final LineIterator lineIterator(InputStream inputStream, String string) {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    public static final InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static final InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(((Object)charSequence).toString(), charset);
    }

    public static final InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    public static final InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static final InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static final InputStream toInputStream(String string, String string2) {
        byte[] byArray = string.getBytes(Charsets.toCharset(string2));
        return new ByteArrayInputStream(byArray);
    }

    public static final void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static final void write(byte[] byArray, Writer writer) {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static final void write(byte[] byArray, Writer writer, Charset charset) {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static final void write(byte[] byArray, Writer writer, String string) {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    public static final void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static final void write(char[] cArray, OutputStream outputStream) {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static final void write(char[] cArray, OutputStream outputStream, Charset charset) {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes(Charsets.toCharset(charset)));
        }
    }

    public static final void write(char[] cArray, OutputStream outputStream, String string) {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static final void write(CharSequence charSequence, Writer writer) {
        if (charSequence != null) {
            IOUtils.write(((Object)charSequence).toString(), writer);
        }
    }

    public static final void write(CharSequence charSequence, OutputStream outputStream) {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static final void write(CharSequence charSequence, OutputStream outputStream, Charset charset) {
        if (charSequence != null) {
            IOUtils.write(((Object)charSequence).toString(), outputStream, charset);
        }
    }

    public static final void write(CharSequence charSequence, OutputStream outputStream, String string) {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static final void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    public static final void write(String string, OutputStream outputStream) {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static final void write(String string, OutputStream outputStream, Charset charset) {
        if (string != null) {
            outputStream.write(string.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static final void write(String string, OutputStream outputStream, String string2) {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    public static final void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static final void write(StringBuffer stringBuffer, OutputStream outputStream) {
        IOUtils.write(stringBuffer, outputStream, (String)null);
    }

    public static final void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes(Charsets.toCharset(string)));
        }
    }

    public static final void writeLines(Collection collection, String string, OutputStream outputStream) {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static final void writeLines(Collection collection, String string, OutputStream outputStream, Charset charset) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        Charset charset2 = Charsets.toCharset(charset);
        for (Object e2 : collection) {
            if (e2 != null) {
                outputStream.write(e2.toString().getBytes(charset2));
            }
            outputStream.write(string.getBytes(charset2));
        }
    }

    public static final void writeLines(Collection collection, String string, OutputStream outputStream, String string2) {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static final void writeLines(Collection collection, String string, Writer writer) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        for (Object e2 : collection) {
            if (e2 != null) {
                writer.write(e2.toString());
            }
            writer.write(string);
        }
    }

    public static final int copy(InputStream inputStream, OutputStream outputStream) {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static final long copyLarge(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copyLarge(inputStream, outputStream, new byte[4096]);
    }

    public static final long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        long l2 = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l2 += (long)n;
        }
        return l2;
    }

    public static final long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, new byte[4096]);
    }

    public static final long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) {
        int n;
        int n2;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n3 = n2 = byArray.length;
        if (l3 > 0L && l3 < (long)n2) {
            n3 = (int)l3;
        }
        long l4 = 0L;
        while (n3 > 0 && -1 != (n = inputStream.read(byArray, 0, n3))) {
            outputStream.write(byArray, 0, n);
            l4 += (long)n;
            if (l3 <= 0L) continue;
            n3 = (int)Math.min(l3 - l4, (long)n2);
        }
        return l4;
    }

    public static final void copy(InputStream inputStream, Writer writer) {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static final void copy(InputStream inputStream, Writer writer, Charset charset) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.toCharset(charset));
        IOUtils.copy((Reader)inputStreamReader, writer);
    }

    public static final void copy(InputStream inputStream, Writer writer, String string) {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static final int copy(Reader reader, Writer writer) {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static final long copyLarge(Reader reader, Writer writer) {
        return IOUtils.copyLarge(reader, writer, new char[4096]);
    }

    public static final long copyLarge(Reader reader, Writer writer, char[] cArray) {
        long l2 = 0L;
        int n = 0;
        while (-1 != (n = reader.read(cArray))) {
            writer.write(cArray, 0, n);
            l2 += (long)n;
        }
        return l2;
    }

    public static final long copyLarge(Reader reader, Writer writer, long l2, long l3) {
        return IOUtils.copyLarge(reader, writer, l2, l3, new char[4096]);
    }

    public static final long copyLarge(Reader reader, Writer writer, long l2, long l3, char[] cArray) {
        int n;
        if (l2 > 0L) {
            IOUtils.skipFully(reader, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n2 = cArray.length;
        if (l3 > 0L && l3 < (long)cArray.length) {
            n2 = (int)l3;
        }
        long l4 = 0L;
        while (n2 > 0 && -1 != (n = reader.read(cArray, 0, n2))) {
            writer.write(cArray, 0, n);
            l4 += (long)n;
            if (l3 <= 0L) continue;
            n2 = (int)Math.min(l3 - l4, (long)cArray.length);
        }
        return l4;
    }

    public static final void copy(Reader reader, OutputStream outputStream) {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static final void copy(Reader reader, OutputStream outputStream, Charset charset) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static final void copy(Reader reader, OutputStream outputStream, String string) {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static final boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (-1 != n2) {
            n = inputStream2.read();
            if (n2 != n) {
                return false;
            }
            n2 = inputStream.read();
        }
        n = inputStream2.read();
        return n == -1;
    }

    public static final boolean contentEquals(Reader reader, Reader reader2) {
        int n;
        reader = IOUtils.toBufferedReader(reader);
        reader2 = IOUtils.toBufferedReader(reader2);
        int n2 = reader.read();
        while (-1 != n2) {
            n = reader2.read();
            if (n2 != n) {
                return false;
            }
            n2 = reader.read();
        }
        n = reader2.read();
        return n == -1;
    }

    public static final boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) {
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        BufferedReader bufferedReader2 = IOUtils.toBufferedReader(reader2);
        String string = bufferedReader.readLine();
        String string2 = bufferedReader2.readLine();
        while (string != null && string2 != null && string.equals(string2)) {
            string = bufferedReader.readLine();
            string2 = bufferedReader2.readLine();
        }
        return string == null ? string2 == null : string.equals(string2);
    }

    public static final long skip(InputStream inputStream, long l2) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (SKIP_BYTE_BUFFER == null) {
            SKIP_BYTE_BUFFER = new byte[2048];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(l3, 2048L))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static final long skip(Reader reader, long l2) {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[2048];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)reader.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(l3, 2048L))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static final void skipFully(InputStream inputStream, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(inputStream, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static final void skipFully(Reader reader, long l2) {
        long l3 = IOUtils.skip(reader, l2);
        if (l3 != l2) {
            throw new EOFException("Chars to skip: " + l2 + " actual: " + l3);
        }
    }

    public static final int read(Reader reader, char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n2);
        }
        for (n4 = n2; n4 > 0 && -1 != (n5 = reader.read(cArray, n + (n3 = n2 - n4), n4)); n4 -= n5) {
        }
        return n2 - n4;
    }

    public static final int read(Reader reader, char[] cArray) {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static final int read(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n2);
        }
        for (n4 = n2; n4 > 0 && -1 != (n5 = inputStream.read(byArray, n + (n3 = n2 - n4), n4)); n4 -= n5) {
        }
        return n2 - n4;
    }

    public static final int read(InputStream inputStream, byte[] byArray) {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static final void readFully(Reader reader, char[] cArray, int n, int n2) {
        int n3 = IOUtils.read(reader, cArray, n, n2);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    public static final void readFully(Reader reader, char[] cArray) {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static final void readFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3 = IOUtils.read(inputStream, byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    public static final void readFully(InputStream inputStream, byte[] byArray) {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    static {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(4);
        PrintWriter printWriter = new PrintWriter(stringBuilderWriter);
        printWriter.println();
        LINE_SEPARATOR = stringBuilderWriter.toString();
        printWriter.close();
    }
}

