/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.waitwithstyle;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import net.java.swingfx.waitwithstyle.CancelableAdaptee;
import net.java.swingfx.waitwithstyle.CancelableProgessAdapter;
import net.java.swingfx.waitwithstyle.InfiniteProgressAdapter;
import net.java.swingfx.waitwithstyle.InfiniteProgressPanel$Animator;
import net.java.swingfx.waitwithstyle.InfiniteProgressPanel$Ticker;

public class InfiniteProgressPanel
extends JComponent
implements MouseListener,
CancelableAdaptee {
    private static final long serialVersionUID = 3546080263571714356L;
    protected InfiniteProgressPanel$Ticker ticker = null;
    protected Thread animation = null;
    protected boolean started = false;
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.7f;
    protected String text = "";
    protected int barsCount = 14;
    protected float fps = 15.0f;
    protected RenderingHints hints = null;
    protected InfiniteProgressAdapter infiniteProgressAdapter = null;

    public InfiniteProgressPanel() {
        this("");
    }

    public InfiniteProgressPanel(String string) {
        this(string, 14);
    }

    public InfiniteProgressPanel(String string, int n) {
        this(string, n, 0.7f);
    }

    public InfiniteProgressPanel(String string, int n, float f2) {
        this(string, n, f2, 15.0f);
    }

    public InfiniteProgressPanel(String string, int n, float f2, float f3) {
        this(string, n, f2, f3, 300);
    }

    public InfiniteProgressPanel(String string, int n, float f2, float f3, int n2) {
        this.text = string;
        this.rampDelay = n2 >= 0 ? n2 : 0;
        this.shield = f2 >= 0.0f ? f2 : 0.0f;
        this.fps = f3 > 0.0f ? f3 : 15.0f;
        this.barsCount = n > 0 ? n : 14;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setText(String string) {
        this.text = string;
        this.repaint();
    }

    public final String getText() {
        return this.text;
    }

    public final void setInfiniteProgressAdapter(InfiniteProgressAdapter infiniteProgressAdapter) {
        this.infiniteProgressAdapter = infiniteProgressAdapter;
    }

    public void addCancelListener(ActionListener actionListener) {
        if (!(this.infiniteProgressAdapter instanceof CancelableProgessAdapter)) {
            throw new RuntimeException("Expected CancelableProgessAdapter for cancel listener.  Adapter is " + this.infiniteProgressAdapter);
        }
        ((CancelableProgessAdapter)this.infiniteProgressAdapter).addCancelListener(actionListener);
    }

    public void removeCancelListener(ActionListener actionListener) {
        if (!(this.infiniteProgressAdapter instanceof CancelableProgessAdapter)) {
            throw new RuntimeException("Expected CancelableProgessAdapter for cancel listener.  Adapter is " + this.infiniteProgressAdapter);
        }
        ((CancelableProgessAdapter)this.infiniteProgressAdapter).removeCancelListener(actionListener);
    }

    public void start() {
        this.addMouseListener(this);
        this.setVisible(true);
        this.buildTicker();
        this.animation = new Thread(new InfiniteProgressPanel$Animator(this, true));
        if (this.infiniteProgressAdapter != null) {
            this.infiniteProgressAdapter.animationStarting();
        }
        this.animation.start();
    }

    public void stop() {
        if (this.infiniteProgressAdapter != null) {
            this.infiniteProgressAdapter.animationStopping();
        }
        if (this.animation != null) {
            this.animation.interrupt();
            try {
                this.animation.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.animation = null;
            this.animation = new Thread(new InfiniteProgressPanel$Animator(this, false));
            this.animation.start();
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public final void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    public final void paintComponent(Graphics graphics) {
        if (this.started) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0 || n2 == 0) {
                return;
            }
            InfiniteProgressPanel$Ticker infiniteProgressPanel$Ticker = this.getTicker();
            if (infiniteProgressPanel$Ticker == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHints(this.hints);
            graphics2D.setColor(new Color(255, 255, 255, (int)((float)this.alphaLevel * this.shield)));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i2 = 0; i2 < infiniteProgressPanel$Ticker.bars.length; ++i2) {
                int n3 = 224 - 128 / (i2 + 1);
                graphics2D.setColor(new Color(n3, n3, n3, this.alphaLevel));
                graphics2D.fill(infiniteProgressPanel$Ticker.bars[i2]);
            }
            double d2 = InfiniteProgressPanel.drawTextAt(this.text, this.getFont(), graphics2D, n, infiniteProgressPanel$Ticker.maxY, this.getForeground());
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.paintSubComponents(d2);
            }
        }
    }

    public static final double drawTextAt(String string, Font font, Graphics2D graphics2D, int n, double d2, Color color) {
        if (string != null && string.length() > 0) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            graphics2D.setColor(color);
            float f2 = (float)((double)n - rectangle2D.getWidth()) / 2.0f;
            d2 = (float)(d2 + (double)textLayout.getLeading() + (double)(2.0f * textLayout.getAscent()));
            textLayout.draw(graphics2D, f2, (float)d2);
        }
        return d2;
    }

    private InfiniteProgressPanel$Ticker getTicker() {
        if (this.ticker == null) {
            this.buildTicker();
        }
        return this.ticker;
    }

    private void buildTicker() {
        Area[] areaArray = new Area[this.barsCount];
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double((double)n / 2.0, (double)n2 / 2.0);
        double d2 = Math.PI * 2 / (double)this.barsCount;
        double d3 = 0.0;
        for (double d4 = 0.0; d4 < (double)this.barsCount; d4 += 1.0) {
            Area area = this.buildPrimitive();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(double_.getX(), double_.getY());
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(45.0, -6.0);
            AffineTransform affineTransform3 = AffineTransform.getRotateInstance(-d4 * d2, double_.getX(), double_.getY());
            AffineTransform affineTransform4 = new AffineTransform();
            affineTransform4.concatenate(affineTransform);
            affineTransform4.concatenate(affineTransform2);
            area.transform(affineTransform4);
            area.transform(affineTransform3);
            areaArray[(int)d4] = area;
            Rectangle2D rectangle2D = area.getBounds2D();
            if (!(rectangle2D.getMaxY() > d3)) continue;
            d3 = rectangle2D.getMaxY();
        }
        this.ticker = new InfiniteProgressPanel$Ticker(this, null);
        this.ticker.bars = areaArray;
        this.ticker.maxY = d3;
    }

    private Area buildPrimitive() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(6.0, 0.0, 30.0, 12.0);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, 0.0, 12.0, 12.0);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(30.0, 0.0, 12.0, 12.0);
        Area area = new Area(double_);
        area.add(new Area(double_2));
        area.add(new Area(double_3));
        return area;
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    public final void mousePressed(MouseEvent mouseEvent) {
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    static final InfiniteProgressPanel$Ticker access$100(InfiniteProgressPanel infiniteProgressPanel) {
        return infiniteProgressPanel.getTicker();
    }
}

