/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class SSTRecord
extends WritableRecordData {
    private int numReferences;
    private int numStrings;
    private ArrayList strings;
    private ArrayList stringLengths;
    private byte[] data;
    private int byteCount;
    private static int maxBytes = 8216;

    public SSTRecord(int n, int n2) {
        super(Type.SST);
        this.numReferences = n;
        this.numStrings = n2;
        this.byteCount = 0;
        this.strings = new ArrayList(50);
        this.stringLengths = new ArrayList(50);
    }

    public final int add(String string) {
        int n = string.length() * 2 + 3;
        if (this.byteCount >= maxBytes - 5) {
            return string.length() > 0 ? string.length() : -1;
        }
        this.stringLengths.add(new Integer(string.length()));
        if (n + this.byteCount < maxBytes) {
            this.strings.add(string);
            this.byteCount += n;
            return 0;
        }
        int n2 = maxBytes - 3 - this.byteCount;
        int n3 = n2 % 2 == 0 ? n2 / 2 : (n2 - 1) / 2;
        this.strings.add(string.substring(0, n3));
        this.byteCount += n3 * 2 + 3;
        return string.length() - n3;
    }

    public final int getOffset() {
        return this.byteCount + 8;
    }

    public final byte[] getData() {
        this.data = new byte[this.byteCount + 8];
        IntegerHelper.getFourBytes(this.numReferences, this.data, 0);
        IntegerHelper.getFourBytes(this.numStrings, this.data, 4);
        int n = 8;
        int n2 = 0;
        Iterator iterator = this.strings.iterator();
        String string = null;
        int n3 = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            n3 = (Integer)this.stringLengths.get(n2);
            IntegerHelper.getTwoBytes(n3, this.data, n);
            this.data[n + 2] = 1;
            StringHelper.getUnicodeBytes(string, this.data, n + 3);
            n += string.length() * 2 + 3;
            ++n2;
        }
        return this.data;
    }
}

