/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.SheetRangeImpl;
import jxl.write.Blank;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.File;
import jxl.write.biff.MergedCellsRecord;
import jxl.write.biff.WritableSheetImpl;

class MergedCells {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$MergedCells == null ? (class$jxl$write$biff$MergedCells = MergedCells.class$("jxl.write.biff.MergedCells")) : class$jxl$write$biff$MergedCells);
    private ArrayList ranges = new ArrayList();
    private WritableSheet sheet;
    private static final int maxRangesPerSheet = 1020;
    static Class class$jxl$write$biff$MergedCells;

    public MergedCells(WritableSheet writableSheet) {
        this.sheet = writableSheet;
    }

    final void add(Range range) {
        this.ranges.add(range);
    }

    final void insertRow(int n) {
        SheetRangeImpl sheetRangeImpl = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            sheetRangeImpl = (SheetRangeImpl)iterator.next();
            sheetRangeImpl.insertRow(n);
        }
    }

    final void insertColumn(int n) {
        SheetRangeImpl sheetRangeImpl = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            sheetRangeImpl = (SheetRangeImpl)iterator.next();
            sheetRangeImpl.insertColumn(n);
        }
    }

    final void removeColumn(int n) {
        SheetRangeImpl sheetRangeImpl = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            sheetRangeImpl = (SheetRangeImpl)iterator.next();
            if (sheetRangeImpl.getTopLeft().getColumn() == n && sheetRangeImpl.getBottomRight().getColumn() == n) {
                this.ranges.remove(this.ranges.indexOf(sheetRangeImpl));
                continue;
            }
            sheetRangeImpl.removeColumn(n);
        }
    }

    final void removeRow(int n) {
        SheetRangeImpl sheetRangeImpl = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            sheetRangeImpl = (SheetRangeImpl)iterator.next();
            if (sheetRangeImpl.getTopLeft().getRow() == n && sheetRangeImpl.getBottomRight().getRow() == n) {
                iterator.remove();
                continue;
            }
            sheetRangeImpl.removeRow(n);
        }
    }

    final Range[] getMergedCells() {
        Range[] rangeArray = new Range[this.ranges.size()];
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            rangeArray[i2] = (Range)this.ranges.get(i2);
        }
        return rangeArray;
    }

    final void unmergeCells(Range range) {
        int n = this.ranges.indexOf(range);
        if (n != -1) {
            this.ranges.remove(n);
        }
    }

    private void checkIntersections() {
        ArrayList<SheetRangeImpl> arrayList = new ArrayList<SheetRangeImpl>(this.ranges.size());
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            SheetRangeImpl sheetRangeImpl = (SheetRangeImpl)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            SheetRangeImpl sheetRangeImpl2 = null;
            boolean bl = false;
            while (iterator2.hasNext() && !bl) {
                sheetRangeImpl2 = (SheetRangeImpl)iterator2.next();
                if (!sheetRangeImpl2.intersects(sheetRangeImpl)) continue;
                logger.warn("Could not merge cells " + sheetRangeImpl + " as they clash with an existing set of merged cells.");
                bl = true;
            }
            if (bl) continue;
            arrayList.add(sheetRangeImpl);
        }
        this.ranges = arrayList;
    }

    private void checkRanges() {
        try {
            SheetRangeImpl sheetRangeImpl = null;
            for (int i2 = 0; i2 < this.ranges.size(); ++i2) {
                sheetRangeImpl = (SheetRangeImpl)this.ranges.get(i2);
                Cell cell = sheetRangeImpl.getTopLeft();
                Cell cell2 = sheetRangeImpl.getBottomRight();
                boolean bl = false;
                for (int i3 = cell.getColumn(); i3 <= cell2.getColumn(); ++i3) {
                    for (int i4 = cell.getRow(); i4 <= cell2.getRow(); ++i4) {
                        Cell cell3 = this.sheet.getCell(i3, i4);
                        if (cell3.getType() == CellType.EMPTY) continue;
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        logger.warn("Range " + sheetRangeImpl + " contains more than one data cell.  " + "Setting the other cells to blank.");
                        Blank blank = new Blank(i3, i4);
                        this.sheet.addCell(blank);
                    }
                }
            }
        }
        catch (WriteException writeException) {
            Assert.verify(false);
        }
    }

    final void write(File file) {
        if (this.ranges.size() == 0) {
            return;
        }
        WorkbookSettings workbookSettings = ((WritableSheetImpl)this.sheet).getWorkbookSettings();
        if (!workbookSettings.getMergedCellCheckingDisabled()) {
            this.checkIntersections();
            this.checkRanges();
        }
        if (this.ranges.size() < 1020) {
            MergedCellsRecord mergedCellsRecord = new MergedCellsRecord(this.ranges);
            file.write(mergedCellsRecord);
            return;
        }
        int n = this.ranges.size() / 1020 + 1;
        int n2 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            int n3 = Math.min(1020, this.ranges.size() - n2);
            ArrayList arrayList = new ArrayList(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                arrayList.add(this.ranges.get(n2 + i3));
            }
            MergedCellsRecord mergedCellsRecord = new MergedCellsRecord(arrayList);
            file.write(mergedCellsRecord);
            n2 += n3;
        }
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

