/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import jxl.CellType;
import jxl.LabelCell;
import jxl.StringFormulaCell;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.CellValue;
import jxl.read.biff.File;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class StringFormulaRecord
extends CellValue
implements LabelCell,
FormulaData,
StringFormulaCell {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$StringFormulaRecord == null ? (class$jxl$read$biff$StringFormulaRecord = StringFormulaRecord.class$("jxl.read.biff.StringFormulaRecord")) : class$jxl$read$biff$StringFormulaRecord);
    private String value;
    private ExternalSheet externalSheet;
    private WorkbookMethods nameTable;
    private String formulaString;
    private byte[] data;
    static Class class$jxl$read$biff$StringFormulaRecord;

    public StringFormulaRecord(Record record, File file, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl, WorkbookSettings workbookSettings) {
        super(record, formattingRecords, sheetImpl);
        int n;
        this.externalSheet = externalSheet;
        this.nameTable = workbookMethods;
        this.data = this.getRecord().getData();
        int n2 = file.getPos();
        Record record2 = file.next();
        for (n = 0; record2.getType() != Type.STRING && n < 4; ++n) {
            record2 = file.next();
        }
        Assert.verify(n < 4, " @ " + n2);
        this.readString(record2.getData(), workbookSettings);
    }

    public StringFormulaRecord(Record record, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl) {
        super(record, formattingRecords, sheetImpl);
        this.externalSheet = externalSheet;
        this.nameTable = workbookMethods;
        this.data = this.getRecord().getData();
        this.value = "";
    }

    private void readString(byte[] byArray, WorkbookSettings workbookSettings) {
        boolean bl;
        int n = 0;
        int n2 = IntegerHelper.getInt(byArray[0], byArray[1]);
        if (n2 == 0) {
            this.value = "";
            return;
        }
        byte by = byArray[n += 2];
        ++n;
        if ((by & 0xF) != by) {
            n = 0;
            n2 = IntegerHelper.getInt(byArray[0], (byte)0);
            by = byArray[1];
            n = 2;
        }
        boolean bl2 = (by & 4) != 0;
        boolean bl3 = bl = (by & 8) != 0;
        if (bl) {
            n += 2;
        }
        if (bl2) {
            n += 4;
        }
        boolean bl4 = (by & 1) == 0;
        this.value = bl4 ? StringHelper.getString(byArray, n2, n, workbookSettings) : StringHelper.getUnicodeString(byArray, n2, n);
    }

    public final String getContents() {
        return this.value;
    }

    public final String getString() {
        return this.value;
    }

    public final CellType getType() {
        return CellType.STRING_FORMULA;
    }

    public final byte[] getFormulaData() {
        if (!this.getSheet().getWorkbook().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.biff8Supported);
        }
        byte[] byArray = new byte[this.data.length - 6];
        System.arraycopy(this.data, 6, byArray, 0, this.data.length - 6);
        return byArray;
    }

    public final String getFormula() {
        if (this.formulaString == null) {
            byte[] byArray = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, byArray, 0, byArray.length);
            FormulaParser formulaParser = new FormulaParser(byArray, this, this.externalSheet, this.nameTable, this.getSheet().getWorkbook().getSettings());
            formulaParser.parse();
            this.formulaString = formulaParser.getFormula();
        }
        return this.formulaString;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

