/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.Type;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.format.CellFormat;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.ButtonPropertySetRecord;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DataValidation;
import jxl.read.biff.File;
import jxl.read.biff.PLSRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SheetReader;
import jxl.read.biff.WorkbookParser;

public class SheetImpl
implements Sheet {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private String name;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ColumnInfoRecord[] columnInfos;
    private RowRecord[] rowRecords;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private ArrayList charts;
    private ArrayList drawings;
    private ArrayList images;
    private DataValidation dataValidation;
    private Range[] mergedCells;
    private boolean columnInfosInitialized;
    private boolean rowRecordsInitialized;
    private boolean nineteenFour;
    private WorkspaceInformationRecord workspaceOptions;
    private boolean hidden;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private SheetSettings settings;
    private int[] rowBreaks;
    private WorkbookParser workbook;
    private WorkbookSettings workbookSettings;

    SheetImpl(File file, SSTRecord sSTRecord, FormattingRecords formattingRecords, BOFRecord bOFRecord, BOFRecord bOFRecord2, boolean bl, WorkbookParser workbookParser) {
        this.excelFile = file;
        this.sharedStrings = sSTRecord;
        this.formattingRecords = formattingRecords;
        this.sheetBof = bOFRecord;
        this.workbookBof = bOFRecord2;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.columnInfosInitialized = false;
        this.rowRecordsInitialized = false;
        this.nineteenFour = bl;
        this.workbook = workbookParser;
        this.workbookSettings = this.workbook.getSettings();
        this.startPosition = file.getPos();
        if (this.sheetBof.isChart()) {
            this.startPosition -= this.sheetBof.getLength() + 4;
        }
        Record record = null;
        int n = 1;
        while (n >= 1) {
            record = file.next();
            if (record.getCode() == Type.EOF.value) {
                --n;
            }
            if (record.getCode() != Type.BOF.value) continue;
            ++n;
        }
    }

    public final Cell getCell(int n, int n2) {
        Cell cell;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((cell = this.cells[n2][n]) == null) {
            this.cells[n2][n] = cell = new EmptyCell(n, n2);
        }
        return cell;
    }

    public final Cell findCell(String string) {
        Cell cell = null;
        boolean bl = false;
        for (int i2 = 0; i2 < this.getRows() && !bl; ++i2) {
            Cell[] cellArray = this.getRow(i2);
            for (int i3 = 0; i3 < cellArray.length && !bl; ++i3) {
                if (!cellArray[i3].getContents().equals(string)) continue;
                cell = cellArray[i3];
                bl = true;
            }
        }
        return cell;
    }

    public final LabelCell findLabelCell(String string) {
        LabelCell labelCell = null;
        boolean bl = false;
        for (int i2 = 0; i2 < this.getRows() && !bl; ++i2) {
            Cell[] cellArray = this.getRow(i2);
            for (int i3 = 0; i3 < cellArray.length && !bl; ++i3) {
                if (cellArray[i3].getType() != CellType.LABEL && cellArray[i3].getType() != CellType.STRING_FORMULA || !cellArray[i3].getContents().equals(string)) continue;
                labelCell = (LabelCell)cellArray[i3];
                bl = true;
            }
        }
        return labelCell;
    }

    public final int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public final int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public final Cell[] getRow(int n) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean bl = false;
        int n2 = this.numCols - 1;
        while (n2 >= 0 && !bl) {
            if (this.cells[n][n2] != null) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            cellArray[i2] = this.getCell(i2, n);
        }
        return cellArray;
    }

    public final Cell[] getColumn(int n) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean bl = false;
        int n2 = this.numRows - 1;
        while (n2 >= 0 && !bl) {
            if (this.cells[n2][n] != null) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            cellArray[i2] = this.getCell(n, i2);
        }
        return cellArray;
    }

    public final String getName() {
        return this.name;
    }

    final void setName(String string) {
        this.name = string;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final ColumnInfoRecord getColumnInfo(int n) {
        if (!this.columnInfosInitialized) {
            Iterator iterator = this.columnInfosArray.iterator();
            ColumnInfoRecord columnInfoRecord = null;
            while (iterator.hasNext()) {
                columnInfoRecord = (ColumnInfoRecord)iterator.next();
                int n2 = Math.max(0, columnInfoRecord.getStartColumn());
                int n3 = Math.min(this.columnInfos.length - 1, columnInfoRecord.getEndColumn());
                for (int i2 = n2; i2 <= n3; ++i2) {
                    this.columnInfos[i2] = columnInfoRecord;
                }
                if (n3 >= n2) continue;
                this.columnInfos[n2] = columnInfoRecord;
            }
            this.columnInfosInitialized = true;
        }
        return n < this.columnInfos.length ? this.columnInfos[n] : null;
    }

    public final ColumnInfoRecord[] getColumnInfos() {
        ColumnInfoRecord[] columnInfoRecordArray = new ColumnInfoRecord[this.columnInfosArray.size()];
        for (int i2 = 0; i2 < this.columnInfosArray.size(); ++i2) {
            columnInfoRecordArray[i2] = (ColumnInfoRecord)this.columnInfosArray.get(i2);
        }
        return columnInfoRecordArray;
    }

    final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    final void clear() {
        this.cells = null;
        this.mergedCells = null;
        this.columnInfosArray.clear();
        this.sharedFormulas.clear();
        this.hyperlinks.clear();
        this.columnInfosInitialized = false;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    final void readSheet() {
        if (!this.sheetBof.isWorksheet()) {
            this.numRows = 0;
            this.numCols = 0;
            this.cells = new Cell[0][0];
        }
        SheetReader sheetReader = new SheetReader(this.excelFile, this.sharedStrings, this.formattingRecords, this.sheetBof, this.workbookBof, this.nineteenFour, this.workbook, this.startPosition, this);
        sheetReader.read();
        this.numRows = sheetReader.getNumRows();
        this.numCols = sheetReader.getNumCols();
        this.cells = sheetReader.getCells();
        this.rowProperties = sheetReader.getRowProperties();
        this.columnInfosArray = sheetReader.getColumnInfosArray();
        this.hyperlinks = sheetReader.getHyperlinks();
        this.charts = sheetReader.getCharts();
        this.drawings = sheetReader.getDrawings();
        this.dataValidation = sheetReader.getDataValidation();
        this.mergedCells = sheetReader.getMergedCells();
        this.settings = sheetReader.getSettings();
        this.settings.setHidden(this.hidden);
        this.rowBreaks = sheetReader.getRowBreaks();
        this.workspaceOptions = sheetReader.getWorkspaceOptions();
        this.plsRecord = sheetReader.getPLS();
        this.buttonPropertySet = sheetReader.getButtonPropertySet();
        sheetReader = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
        if (this.columnInfosArray.size() > 0) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.columnInfosArray.get(this.columnInfosArray.size() - 1);
            this.columnInfos = new ColumnInfoRecord[columnInfoRecord.getEndColumn() + 1];
        } else {
            this.columnInfos = new ColumnInfoRecord[0];
        }
    }

    public final Hyperlink[] getHyperlinks() {
        Hyperlink[] hyperlinkArray = new Hyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            hyperlinkArray[i2] = (Hyperlink)this.hyperlinks.get(i2);
        }
        return hyperlinkArray;
    }

    public final Range[] getMergedCells() {
        if (this.mergedCells == null) {
            return new Range[0];
        }
        return this.mergedCells;
    }

    public final RowRecord[] getRowProperties() {
        RowRecord[] rowRecordArray = new RowRecord[this.rowProperties.size()];
        for (int i2 = 0; i2 < rowRecordArray.length; ++i2) {
            rowRecordArray[i2] = (RowRecord)this.rowProperties.get(i2);
        }
        return rowRecordArray;
    }

    public final DataValidation getDataValidation() {
        return this.dataValidation;
    }

    final RowRecord getRowInfo(int n) {
        if (!this.rowRecordsInitialized) {
            this.rowRecords = new RowRecord[this.getRows()];
            Iterator iterator = this.rowProperties.iterator();
            int n2 = 0;
            RowRecord rowRecord = null;
            while (iterator.hasNext()) {
                rowRecord = (RowRecord)iterator.next();
                n2 = rowRecord.getRowNumber();
                if (n2 >= this.rowRecords.length) continue;
                this.rowRecords[n2] = rowRecord;
            }
            this.rowRecordsInitialized = true;
        }
        return this.rowRecords[n];
    }

    public final int[] getRowPageBreaks() {
        return this.rowBreaks;
    }

    public final Chart[] getCharts() {
        Chart[] chartArray = new Chart[this.charts.size()];
        for (int i2 = 0; i2 < chartArray.length; ++i2) {
            chartArray[i2] = (Chart)this.charts.get(i2);
        }
        return chartArray;
    }

    public final DrawingGroupObject[] getDrawings() {
        DrawingGroupObject[] drawingGroupObjectArray = new DrawingGroupObject[this.drawings.size()];
        drawingGroupObjectArray = this.drawings.toArray(drawingGroupObjectArray);
        return drawingGroupObjectArray;
    }

    public final boolean isProtected() {
        return this.settings.isProtected();
    }

    public final WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    public final SheetSettings getSettings() {
        return this.settings;
    }

    final WorkbookParser getWorkbook() {
        return this.workbook;
    }

    public final CellFormat getColumnFormat(int n) {
        CellView cellView = this.getColumnView(n);
        return cellView.getFormat();
    }

    public final int getColumnWidth(int n) {
        return this.getColumnView(n).getSize() / 256;
    }

    public final CellView getColumnView(int n) {
        ColumnInfoRecord columnInfoRecord = this.getColumnInfo(n);
        CellView cellView = new CellView();
        if (columnInfoRecord != null) {
            cellView.setDimension(columnInfoRecord.getWidth() / 256);
            cellView.setSize(columnInfoRecord.getWidth());
            cellView.setHidden(columnInfoRecord.getHidden());
            cellView.setFormat(this.formattingRecords.getXFRecord(columnInfoRecord.getXFIndex()));
        } else {
            cellView.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cellView.setSize(this.settings.getDefaultColumnWidth());
        }
        return cellView;
    }

    public final int getRowHeight(int n) {
        return this.getRowView(n).getDimension();
    }

    public final CellView getRowView(int n) {
        RowRecord rowRecord = this.getRowInfo(n);
        CellView cellView = new CellView();
        if (rowRecord != null) {
            cellView.setDimension(rowRecord.getRowHeight());
            cellView.setSize(rowRecord.getRowHeight());
            cellView.setHidden(rowRecord.isCollapsed());
        } else {
            cellView.setDimension(this.settings.getDefaultRowHeight());
            cellView.setSize(this.settings.getDefaultRowHeight());
        }
        return cellView;
    }

    public final BOFRecord getSheetBof() {
        return this.sheetBof;
    }

    public final BOFRecord getWorkbookBof() {
        return this.workbookBof;
    }

    public final PLSRecord getPLS() {
        return this.plsRecord;
    }

    public final ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    public final int getNumberOfImages() {
        if (this.images == null) {
            this.initializeImages();
        }
        return this.images.size();
    }

    public final Image getDrawing(int n) {
        if (this.images == null) {
            this.initializeImages();
        }
        return (Image)this.images.get(n);
    }

    private void initializeImages() {
        if (this.images != null) {
            return;
        }
        this.images = new ArrayList();
        DrawingGroupObject[] drawingGroupObjectArray = this.getDrawings();
        for (int i2 = 0; i2 < drawingGroupObjectArray.length; ++i2) {
            if (!(drawingGroupObjectArray[i2] instanceof Drawing)) continue;
            this.images.add(drawingGroupObjectArray[i2]);
        }
    }
}

