/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.File;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

public class SharedNumberFormulaRecord
extends BaseSharedFormulaRecord
implements NumberCell,
FormulaData,
NumberFormulaCell {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$SharedNumberFormulaRecord == null ? (class$jxl$read$biff$SharedNumberFormulaRecord = SharedNumberFormulaRecord.class$("jxl.read.biff.SharedNumberFormulaRecord")) : class$jxl$read$biff$SharedNumberFormulaRecord);
    private double value;
    private NumberFormat format;
    private FormattingRecords formattingRecords;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");
    static Class class$jxl$read$biff$SharedNumberFormulaRecord;

    public SharedNumberFormulaRecord(Record record, File file, double d2, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl) {
        super(record, formattingRecords, externalSheet, workbookMethods, sheetImpl, file.getPos());
        this.value = d2;
        this.format = defaultFormat;
    }

    final void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat != null) {
            this.format = numberFormat;
        }
    }

    public final double getValue() {
        return this.value;
    }

    public final String getContents() {
        return !Double.isNaN(this.value) ? this.format.format(this.value) : "";
    }

    public final CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public final byte[] getFormulaData() {
        if (!this.getSheet().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.biff8Supported);
        }
        FormulaParser formulaParser = new FormulaParser(this.getTokens(), this, this.getExternalSheet(), this.getNameTable(), this.getSheet().getWorkbook().getSettings());
        formulaParser.parse();
        byte[] byArray = formulaParser.getBytes();
        byte[] byArray2 = new byte[byArray.length + 22];
        IntegerHelper.getTwoBytes(this.getRow(), byArray2, 0);
        IntegerHelper.getTwoBytes(this.getColumn(), byArray2, 2);
        IntegerHelper.getTwoBytes(this.getXFIndex(), byArray2, 4);
        DoubleHelper.getIEEEBytes(this.value, byArray2, 6);
        System.arraycopy(byArray, 0, byArray2, 22, byArray.length);
        IntegerHelper.getTwoBytes(byArray.length, byArray2, 20);
        byte[] byArray3 = new byte[byArray2.length - 6];
        System.arraycopy(byArray2, 6, byArray3, 0, byArray2.length - 6);
        return byArray3;
    }

    public final NumberFormat getNumberFormat() {
        return this.format;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

