/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.io.InputStream;
import java.io.InterruptedIOException;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.Record;

public class File {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$File == null ? (class$jxl$read$biff$File = File.class$("jxl.read.biff.File")) : class$jxl$read$biff$File);
    private byte[] data;
    private int filePos;
    private int oldPos;
    private int initialFileSize;
    private int arrayGrowSize;
    private CompoundFile compoundFile;
    private WorkbookSettings workbookSettings;
    static Class class$jxl$read$biff$File;

    public File(InputStream inputStream, WorkbookSettings workbookSettings) {
        Object object;
        int n;
        this.workbookSettings = workbookSettings;
        this.initialFileSize = this.workbookSettings.getInitialFileSize();
        this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
        Object object2 = new byte[this.initialFileSize];
        int n2 = n = inputStream.read((byte[])object2);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException();
        }
        while (n != -1) {
            if (n2 >= ((byte[])object2).length) {
                object = new byte[((byte[])object2).length + this.arrayGrowSize];
                System.arraycopy(object2, 0, object, 0, ((byte[])object2).length);
                object2 = object;
            }
            n = inputStream.read((byte[])object2, n2, ((byte[])object2).length - n2);
            n2 += n;
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException();
        }
        n = n2 + 1;
        if (n == 0) {
            throw new BiffException(BiffException.excelFileNotFound);
        }
        object = new CompoundFile((byte[])object2, workbookSettings);
        try {
            this.data = ((CompoundFile)object).getStream("workbook");
        }
        catch (BiffException biffException) {
            this.data = ((CompoundFile)object).getStream("book");
        }
        if (!this.workbookSettings.getPropertySetsDisabled() && ((CompoundFile)object).getNumberOfPropertySets() > BaseCompoundFile.STANDARD_PROPERTY_SETS.length) {
            this.compoundFile = object;
        }
        object = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public File(byte[] byArray) {
        this.data = byArray;
    }

    final Record next() {
        Record record = new Record(this.data, this.filePos, this);
        return record;
    }

    final Record peek() {
        int n = this.filePos;
        Record record = new Record(this.data, this.filePos, this);
        this.filePos = n;
        return record;
    }

    public final void skip(int n) {
        this.filePos += n;
    }

    public final byte[] read(int n, int n2) {
        byte[] byArray = new byte[n2];
        try {
            System.arraycopy(this.data, n, byArray, 0, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Array index out of bounds at position " + n + " record length " + n2);
            throw arrayIndexOutOfBoundsException;
        }
        return byArray;
    }

    public final int getPos() {
        return this.filePos;
    }

    public final void setPos(int n) {
        this.oldPos = this.filePos;
        this.filePos = n;
    }

    public final void restorePos() {
        this.filePos = this.oldPos;
    }

    private void moveToFirstBof() {
        boolean bl = false;
        while (!bl) {
            int n = IntegerHelper.getInt(this.data[this.filePos], this.data[this.filePos + 1]);
            if (n == Type.BOF.value) {
                bl = true;
                continue;
            }
            this.skip(128);
        }
    }

    public final void close() {
    }

    public final void clear() {
        this.data = null;
    }

    public final boolean hasNext() {
        return this.filePos < this.data.length - 4;
    }

    final CompoundFile getCompoundFile() {
        return this.compoundFile;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

