/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.NumberFormat;
import jxl.CellType;
import jxl.DateCell;
import jxl.DateFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.DateRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.SheetImpl;

class DateFormulaRecord
extends DateRecord
implements DateCell,
FormulaData,
DateFormulaCell {
    private String formulaString;
    private ExternalSheet externalSheet;
    private WorkbookMethods nameTable;
    private byte[] data;

    public DateFormulaRecord(NumberFormulaRecord numberFormulaRecord, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, boolean bl, SheetImpl sheetImpl) {
        super(numberFormulaRecord, numberFormulaRecord.getXFIndex(), formattingRecords, bl, sheetImpl);
        this.externalSheet = externalSheet;
        this.nameTable = workbookMethods;
        this.data = numberFormulaRecord.getFormulaData();
    }

    public final CellType getType() {
        return CellType.DATE_FORMULA;
    }

    public final byte[] getFormulaData() {
        if (!this.getSheet().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.biff8Supported);
        }
        return this.data;
    }

    public final String getFormula() {
        if (this.formulaString == null) {
            byte[] byArray = new byte[this.data.length - 16];
            System.arraycopy(this.data, 16, byArray, 0, byArray.length);
            FormulaParser formulaParser = new FormulaParser(byArray, this, this.externalSheet, this.nameTable, this.getSheet().getWorkbook().getSettings());
            formulaParser.parse();
            this.formulaString = formulaParser.getFormula();
        }
        return this.formulaString;
    }

    public final double getValue() {
        return 0.0;
    }

    public final NumberFormat getNumberFormat() {
        return null;
    }
}

