/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import jxl.biff.IntegerHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class Dg
extends EscherAtom {
    private byte[] data;
    private int drawingId;
    private int shapeCount;
    private int seed;

    public Dg(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.drawingId = this.getInstance();
        byte[] byArray = this.getBytes();
        this.shapeCount = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.seed = IntegerHelper.getInt(byArray[4], byArray[5], byArray[6], byArray[7]);
    }

    public Dg(int n) {
        super(EscherRecordType.DG);
        this.drawingId = 1;
        this.shapeCount = n + 1;
        this.seed = 1024 + this.shapeCount + 1;
        this.setInstance(this.drawingId);
    }

    public final int getDrawingId() {
        return this.drawingId;
    }

    final byte[] getData() {
        this.data = new byte[8];
        IntegerHelper.getFourBytes(this.shapeCount, this.data, 0);
        IntegerHelper.getFourBytes(this.seed, this.data, 4);
        return this.setHeaderData(this.data);
    }
}

