/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.WorkbookSettings;
import jxl.biff.BuiltInFormat;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.FormatRecord;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord$BiffType;
import jxl.biff.XFRecord$XFType;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Format;
import jxl.format.Orientation;
import jxl.format.Pattern;
import jxl.format.VerticalAlignment;
import jxl.read.biff.Record;

public class XFRecord
extends WritableRecordData
implements CellFormat {
    private static Logger logger = Logger.getLogger(class$jxl$biff$XFRecord == null ? (class$jxl$biff$XFRecord = XFRecord.class$("jxl.biff.XFRecord")) : class$jxl$biff$XFRecord);
    public int formatIndex;
    private int parentFormat;
    private XFRecord$XFType xfFormatType;
    private boolean date;
    private boolean number;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private byte usedAttributes;
    private int fontIndex;
    private boolean locked;
    private boolean hidden;
    private Alignment align;
    private VerticalAlignment valign;
    private Orientation orientation;
    private boolean wrap;
    private int indentation;
    private boolean shrinkToFit;
    private BorderLineStyle leftBorder;
    private BorderLineStyle rightBorder;
    private BorderLineStyle topBorder;
    private BorderLineStyle bottomBorder;
    private Colour leftBorderColour;
    private Colour rightBorderColour;
    private Colour topBorderColour;
    private Colour bottomBorderColour;
    private Colour backgroundColour;
    private Pattern pattern;
    private int options;
    private int xfIndex;
    private FontRecord font;
    private DisplayFormat format;
    private boolean initialized;
    private boolean read;
    private Format excelFormat;
    private boolean formatInfoInitialized;
    private boolean copied;
    private FormattingRecords formattingRecords;
    private static final int[] dateFormats = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 45, 46, 47};
    private static final DateFormat[] javaDateFormats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("d-MMM"), new SimpleDateFormat("MMM-yy"), new SimpleDateFormat("h:mm a"), new SimpleDateFormat("h:mm:ss a"), new SimpleDateFormat("H:mm"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("M/d/yy H:mm"), new SimpleDateFormat("mm:ss"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("mm:ss.S")};
    private static int[] numberFormats = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 37, 38, 39, 40, 41, 42, 43, 44, 48};
    private static NumberFormat[] javaNumberFormats = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.00"), new DecimalFormat("#,##0"), new DecimalFormat("#,##0.00"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("0%"), new DecimalFormat("0.00%"), new DecimalFormat("0.00E00"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("##0.0E0")};
    public static final XFRecord$BiffType biff8 = new XFRecord$BiffType(null);
    public static final XFRecord$BiffType biff7 = new XFRecord$BiffType(null);
    private XFRecord$BiffType biffType;
    protected static final XFRecord$XFType cell = new XFRecord$XFType(null);
    protected static final XFRecord$XFType style = new XFRecord$XFType(null);
    static Class class$jxl$biff$XFRecord;

    public XFRecord(Record record, WorkbookSettings workbookSettings, XFRecord$BiffType xFRecord$BiffType) {
        super(record);
        int n;
        this.biffType = xFRecord$BiffType;
        byte[] byArray = this.getRecord().getData();
        this.fontIndex = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.formatIndex = IntegerHelper.getInt(byArray[2], byArray[3]);
        this.date = false;
        this.number = false;
        for (n = 0; n < dateFormats.length && !this.date; ++n) {
            if (this.formatIndex != dateFormats[n]) continue;
            this.date = true;
            this.dateFormat = javaDateFormats[n];
        }
        for (n = 0; n < numberFormats.length && !this.number; ++n) {
            if (this.formatIndex != numberFormats[n]) continue;
            this.number = true;
            DecimalFormat decimalFormat = (DecimalFormat)javaNumberFormats[n].clone();
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(workbookSettings.getLocale());
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            this.numberFormat = decimalFormat;
        }
        n = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.parentFormat = (n & 0xFFF0) >> 4;
        int n2 = n & 4;
        this.xfFormatType = n2 == 0 ? cell : style;
        this.locked = (n & 1) != 0;
        boolean bl = this.hidden = (n & 2) != 0;
        if (this.xfFormatType == cell && (this.parentFormat & 0xFFF) == 4095) {
            this.parentFormat = 0;
            logger.warn("Invalid parent format found - ignoring");
        }
        this.initialized = false;
        this.read = true;
        this.formatInfoInitialized = false;
        this.copied = false;
    }

    public XFRecord(FontRecord fontRecord, DisplayFormat displayFormat) {
        super(Type.XF);
        this.initialized = false;
        this.locked = true;
        this.hidden = false;
        this.align = Alignment.GENERAL;
        this.valign = VerticalAlignment.BOTTOM;
        this.orientation = Orientation.HORIZONTAL;
        this.wrap = false;
        this.leftBorder = BorderLineStyle.NONE;
        this.rightBorder = BorderLineStyle.NONE;
        this.topBorder = BorderLineStyle.NONE;
        this.bottomBorder = BorderLineStyle.NONE;
        this.leftBorderColour = Colour.AUTOMATIC;
        this.rightBorderColour = Colour.AUTOMATIC;
        this.topBorderColour = Colour.AUTOMATIC;
        this.bottomBorderColour = Colour.AUTOMATIC;
        this.pattern = Pattern.NONE;
        this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        this.indentation = 0;
        this.shrinkToFit = false;
        this.parentFormat = 0;
        this.xfFormatType = null;
        this.font = fontRecord;
        this.format = displayFormat;
        this.biffType = biff8;
        this.read = false;
        this.copied = false;
        this.formatInfoInitialized = true;
        Assert.verify(this.font != null);
        Assert.verify(this.format != null);
    }

    protected XFRecord(XFRecord xFRecord) {
        super(Type.XF);
        this.initialized = false;
        this.locked = xFRecord.locked;
        this.hidden = xFRecord.hidden;
        this.align = xFRecord.align;
        this.valign = xFRecord.valign;
        this.orientation = xFRecord.orientation;
        this.wrap = xFRecord.wrap;
        this.leftBorder = xFRecord.leftBorder;
        this.rightBorder = xFRecord.rightBorder;
        this.topBorder = xFRecord.topBorder;
        this.bottomBorder = xFRecord.bottomBorder;
        this.leftBorderColour = xFRecord.leftBorderColour;
        this.rightBorderColour = xFRecord.rightBorderColour;
        this.topBorderColour = xFRecord.topBorderColour;
        this.bottomBorderColour = xFRecord.bottomBorderColour;
        this.pattern = xFRecord.pattern;
        this.xfFormatType = xFRecord.xfFormatType;
        this.indentation = xFRecord.indentation;
        this.shrinkToFit = xFRecord.shrinkToFit;
        this.parentFormat = xFRecord.parentFormat;
        this.backgroundColour = xFRecord.backgroundColour;
        this.font = xFRecord.font;
        this.format = xFRecord.format;
        this.fontIndex = xFRecord.fontIndex;
        this.formatIndex = xFRecord.formatIndex;
        this.formatInfoInitialized = xFRecord.formatInfoInitialized;
        this.biffType = biff8;
        this.read = false;
        this.copied = true;
    }

    protected XFRecord(CellFormat cellFormat) {
        super(Type.XF);
        Assert.verify(cellFormat != null);
        Assert.verify(cellFormat instanceof XFRecord);
        XFRecord xFRecord = (XFRecord)cellFormat;
        if (!xFRecord.formatInfoInitialized) {
            xFRecord.initializeFormatInformation();
        }
        this.locked = xFRecord.locked;
        this.hidden = xFRecord.hidden;
        this.align = xFRecord.align;
        this.valign = xFRecord.valign;
        this.orientation = xFRecord.orientation;
        this.wrap = xFRecord.wrap;
        this.leftBorder = xFRecord.leftBorder;
        this.rightBorder = xFRecord.rightBorder;
        this.topBorder = xFRecord.topBorder;
        this.bottomBorder = xFRecord.bottomBorder;
        this.leftBorderColour = xFRecord.leftBorderColour;
        this.rightBorderColour = xFRecord.rightBorderColour;
        this.topBorderColour = xFRecord.topBorderColour;
        this.bottomBorderColour = xFRecord.bottomBorderColour;
        this.pattern = xFRecord.pattern;
        this.xfFormatType = xFRecord.xfFormatType;
        this.parentFormat = xFRecord.parentFormat;
        this.indentation = xFRecord.indentation;
        this.shrinkToFit = xFRecord.shrinkToFit;
        this.backgroundColour = xFRecord.backgroundColour;
        this.font = new FontRecord(xFRecord.getFont());
        if (xFRecord.getFormat() == null) {
            this.format = xFRecord.format.isBuiltIn() ? xFRecord.format : new FormatRecord((FormatRecord)xFRecord.format);
        } else if (xFRecord.getFormat() instanceof BuiltInFormat) {
            this.excelFormat = (BuiltInFormat)xFRecord.excelFormat;
            this.format = (BuiltInFormat)xFRecord.excelFormat;
        } else {
            Assert.verify(xFRecord.formatInfoInitialized);
            Assert.verify(xFRecord.excelFormat instanceof FormatRecord);
            FormatRecord formatRecord = new FormatRecord((FormatRecord)xFRecord.excelFormat);
            this.excelFormat = formatRecord;
            this.format = formatRecord;
        }
        this.biffType = biff8;
        this.formatInfoInitialized = true;
        this.read = false;
        this.copied = false;
        this.initialized = false;
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public final int getFormatRecord() {
        return this.formatIndex;
    }

    public final boolean isDate() {
        return this.date;
    }

    public final boolean isNumber() {
        return this.number;
    }

    public final byte[] getData() {
        int n;
        int n2;
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        byte[] byArray = new byte[20];
        IntegerHelper.getTwoBytes(this.fontIndex, byArray, 0);
        IntegerHelper.getTwoBytes(this.formatIndex, byArray, 2);
        int n3 = 0;
        if (this.getLocked()) {
            n3 |= 1;
        }
        if (this.getHidden()) {
            n3 |= 2;
        }
        if (this.xfFormatType == style) {
            n3 |= 4;
            this.parentFormat = 65535;
        }
        IntegerHelper.getTwoBytes(n3 |= this.parentFormat << 4, byArray, 4);
        int n4 = this.align.getValue();
        if (this.wrap) {
            n4 |= 8;
        }
        n4 |= this.valign.getValue() << 4;
        IntegerHelper.getTwoBytes(n4 |= this.orientation.getValue() << 8, byArray, 6);
        byArray[9] = 16;
        int n5 = this.leftBorder.getValue();
        n5 |= this.rightBorder.getValue() << 4;
        n5 |= this.topBorder.getValue() << 8;
        IntegerHelper.getTwoBytes(n5 |= this.bottomBorder.getValue() << 12, byArray, 10);
        if (n5 != 0) {
            n2 = this.leftBorderColour.getValue();
            n = this.rightBorderColour.getValue();
            byte by = (byte)this.topBorderColour.getValue();
            byte by2 = (byte)this.bottomBorderColour.getValue();
            int n6 = n2 & 0x7F | (n & 0x7F) << 7;
            int n7 = by & 0x7F | (by2 & 0x7F) << 7;
            IntegerHelper.getTwoBytes(n6, byArray, 12);
            IntegerHelper.getTwoBytes(n7, byArray, 14);
        }
        n2 = this.pattern.getValue() << 10;
        IntegerHelper.getTwoBytes(n2, byArray, 16);
        n = this.backgroundColour.getValue();
        IntegerHelper.getTwoBytes(n |= 0x2000, byArray, 18);
        this.options |= this.indentation & 0xF;
        this.options = this.shrinkToFit ? (this.options |= 0x10) : (this.options &= 0xEF);
        byArray[8] = (byte)this.options;
        if (this.biffType == biff8) {
            byArray[9] = this.usedAttributes;
        }
        return byArray;
    }

    protected final boolean getLocked() {
        return this.locked;
    }

    protected final boolean getHidden() {
        return this.hidden;
    }

    protected final void setXFLocked(boolean bl) {
        this.locked = bl;
    }

    protected final void setXFCellOptions(int n) {
        this.options |= n;
    }

    protected final void setXFAlignment(Alignment alignment) {
        Assert.verify(!this.initialized);
        this.align = alignment;
    }

    protected final void setXFIndentation(int n) {
        Assert.verify(!this.initialized);
        this.indentation = n;
    }

    protected final void setXFShrinkToFit(boolean bl) {
        Assert.verify(!this.initialized);
        this.shrinkToFit = bl;
    }

    public Alignment getAlignment() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.align;
    }

    public int getIndentation() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.indentation;
    }

    public boolean isShrinkToFit() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.shrinkToFit;
    }

    public boolean isLocked() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.locked;
    }

    public VerticalAlignment getVerticalAlignment() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.valign;
    }

    public Orientation getOrientation() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.orientation;
    }

    protected final void setXFBackground(Colour colour, Pattern pattern) {
        Assert.verify(!this.initialized);
        this.backgroundColour = colour;
        this.pattern = pattern;
    }

    public Colour getBackgroundColour() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.backgroundColour;
    }

    public Pattern getPattern() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.pattern;
    }

    protected final void setXFVerticalAlignment(VerticalAlignment verticalAlignment) {
        Assert.verify(!this.initialized);
        this.valign = verticalAlignment;
    }

    protected final void setXFOrientation(Orientation orientation) {
        Assert.verify(!this.initialized);
        this.orientation = orientation;
    }

    protected final void setXFWrap(boolean bl) {
        Assert.verify(!this.initialized);
        this.wrap = bl;
    }

    public boolean getWrap() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.wrap;
    }

    protected final void setXFBorder(Border border, BorderLineStyle borderLineStyle, Colour colour) {
        Assert.verify(!this.initialized);
        if (colour == Colour.BLACK) {
            colour = Colour.PALETTE_BLACK;
        }
        if (border == Border.LEFT) {
            this.leftBorder = borderLineStyle;
            this.leftBorderColour = colour;
        } else if (border == Border.RIGHT) {
            this.rightBorder = borderLineStyle;
            this.rightBorderColour = colour;
        } else if (border == Border.TOP) {
            this.topBorder = borderLineStyle;
            this.topBorderColour = colour;
        } else if (border == Border.BOTTOM) {
            this.bottomBorder = borderLineStyle;
            this.bottomBorderColour = colour;
        }
    }

    public BorderLineStyle getBorder(Border border) {
        return this.getBorderLine(border);
    }

    public BorderLineStyle getBorderLine(Border border) {
        if (border == Border.NONE || border == Border.ALL) {
            return BorderLineStyle.NONE;
        }
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        if (border == Border.LEFT) {
            return this.leftBorder;
        }
        if (border == Border.RIGHT) {
            return this.rightBorder;
        }
        if (border == Border.TOP) {
            return this.topBorder;
        }
        if (border == Border.BOTTOM) {
            return this.bottomBorder;
        }
        return BorderLineStyle.NONE;
    }

    public Colour getBorderColour(Border border) {
        if (border == Border.NONE || border == Border.ALL) {
            return Colour.PALETTE_BLACK;
        }
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        if (border == Border.LEFT) {
            return this.leftBorderColour;
        }
        if (border == Border.RIGHT) {
            return this.rightBorderColour;
        }
        if (border == Border.TOP) {
            return this.topBorderColour;
        }
        if (border == Border.BOTTOM) {
            return this.bottomBorderColour;
        }
        return Colour.BLACK;
    }

    public final boolean hasBorders() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.leftBorder != BorderLineStyle.NONE || this.rightBorder != BorderLineStyle.NONE || this.topBorder != BorderLineStyle.NONE || this.bottomBorder != BorderLineStyle.NONE;
    }

    public final void initialize(int n, FormattingRecords formattingRecords, Fonts fonts) {
        this.xfIndex = n;
        this.formattingRecords = formattingRecords;
        if (this.read || this.copied) {
            this.initialized = true;
            return;
        }
        if (!this.font.isInitialized()) {
            fonts.addFont(this.font);
        }
        if (!this.format.isInitialized()) {
            formattingRecords.addFormat(this.format);
        }
        this.fontIndex = this.font.getFontIndex();
        this.formatIndex = this.format.getFormatIndex();
        this.initialized = true;
    }

    public final void uninitialize() {
        if (this.initialized) {
            logger.warn("A default format has been initialized");
        }
        this.initialized = false;
    }

    final void setXFIndex(int n) {
        this.xfIndex = n;
    }

    public final int getXFIndex() {
        return this.xfIndex;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final boolean isRead() {
        return this.read;
    }

    public Format getFormat() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.excelFormat;
    }

    public Font getFont() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.font;
    }

    private void initializeFormatInformation() {
        int n;
        this.excelFormat = this.formatIndex < BuiltInFormat.builtIns.length && BuiltInFormat.builtIns[this.formatIndex] != null ? BuiltInFormat.builtIns[this.formatIndex] : this.formattingRecords.getFormatRecord(this.formatIndex);
        this.font = this.formattingRecords.getFonts().getFont(this.fontIndex);
        byte[] byArray = this.getRecord().getData();
        int n2 = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.parentFormat = (n2 & 0xFFF0) >> 4;
        int n3 = n2 & 4;
        this.xfFormatType = n3 == 0 ? cell : style;
        this.locked = (n2 & 1) != 0;
        boolean bl = this.hidden = (n2 & 2) != 0;
        if (this.xfFormatType == cell && (this.parentFormat & 0xFFF) == 4095) {
            this.parentFormat = 0;
            logger.warn("Invalid parent format found - ignoring");
        }
        if (((n = IntegerHelper.getInt(byArray[6], byArray[7])) & 8) != 0) {
            this.wrap = true;
        }
        this.align = Alignment.getAlignment(n & 7);
        this.valign = VerticalAlignment.getAlignment(n >> 4 & 7);
        this.orientation = Orientation.getOrientation(n >> 8 & 0xFF);
        int n4 = IntegerHelper.getInt(byArray[8], byArray[9]);
        this.indentation = n4 & 0xF;
        boolean bl2 = this.shrinkToFit = (n4 & 0x10) != 0;
        if (this.biffType == biff8) {
            this.usedAttributes = byArray[9];
        }
        int n5 = IntegerHelper.getInt(byArray[10], byArray[11]);
        this.leftBorder = BorderLineStyle.getStyle(n5 & 7);
        this.rightBorder = BorderLineStyle.getStyle(n5 >> 4 & 7);
        this.topBorder = BorderLineStyle.getStyle(n5 >> 8 & 7);
        this.bottomBorder = BorderLineStyle.getStyle(n5 >> 12 & 7);
        int n6 = IntegerHelper.getInt(byArray[12], byArray[13]);
        this.leftBorderColour = Colour.getInternalColour(n6 & 0x7F);
        this.rightBorderColour = Colour.getInternalColour((n6 & 0x3F80) >> 7);
        n6 = IntegerHelper.getInt(byArray[14], byArray[15]);
        this.topBorderColour = Colour.getInternalColour(n6 & 0x7F);
        this.bottomBorderColour = Colour.getInternalColour((n6 & 0x3F80) >> 7);
        if (this.biffType == biff8) {
            int n7 = IntegerHelper.getInt(byArray[16], byArray[17]);
            n7 &= 0xFC00;
            this.pattern = Pattern.getPattern(n7 >>= 10);
            int n8 = IntegerHelper.getInt(byArray[18], byArray[19]);
            this.backgroundColour = Colour.getInternalColour(n8 & 0x3F);
            if (this.backgroundColour == Colour.UNKNOWN || this.backgroundColour == Colour.DEFAULT_BACKGROUND1) {
                this.backgroundColour = Colour.DEFAULT_BACKGROUND;
            }
        } else {
            this.pattern = Pattern.NONE;
            this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        }
        this.formatInfoInitialized = true;
    }

    public final int hashCode() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        int n = 17;
        int n2 = 37;
        n = n2 * n + (this.hidden ? 1 : 0);
        n = n2 * n + (this.locked ? 1 : 0);
        n = n2 * n + (this.wrap ? 1 : 0);
        n = n2 * n + (this.shrinkToFit ? 1 : 0);
        if (this.xfFormatType == cell) {
            n = n2 * n + 1;
        } else if (this.xfFormatType == style) {
            n = n2 * n + 2;
        }
        n = n2 * n + (this.align.getValue() + 1);
        n = n2 * n + (this.valign.getValue() + 1);
        n = n2 * n + this.orientation.getValue();
        n ^= this.leftBorder.getDescription().hashCode();
        n ^= this.rightBorder.getDescription().hashCode();
        n ^= this.topBorder.getDescription().hashCode();
        n ^= this.bottomBorder.getDescription().hashCode();
        n = n2 * n + this.leftBorderColour.getValue();
        n = n2 * n + this.rightBorderColour.getValue();
        n = n2 * n + this.topBorderColour.getValue();
        n = n2 * n + this.bottomBorderColour.getValue();
        n = n2 * n + this.backgroundColour.getValue();
        n = n2 * n + (this.pattern.getValue() + 1);
        n = n2 * n + this.usedAttributes;
        n = n2 * n + this.parentFormat;
        n = n2 * n + this.fontIndex;
        n = n2 * n + this.formatIndex;
        n = n2 * n + this.indentation;
        return n;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XFRecord)) {
            return false;
        }
        XFRecord xFRecord = (XFRecord)object;
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        if (!xFRecord.formatInfoInitialized) {
            xFRecord.initializeFormatInformation();
        }
        if (this.xfFormatType != xFRecord.xfFormatType || this.parentFormat != xFRecord.parentFormat || this.locked != xFRecord.locked || this.hidden != xFRecord.hidden || this.usedAttributes != xFRecord.usedAttributes) {
            return false;
        }
        if (this.align != xFRecord.align || this.valign != xFRecord.valign || this.orientation != xFRecord.orientation || this.wrap != xFRecord.wrap || this.shrinkToFit != xFRecord.shrinkToFit || this.indentation != xFRecord.indentation) {
            return false;
        }
        if (this.leftBorder != xFRecord.leftBorder || this.rightBorder != xFRecord.rightBorder || this.topBorder != xFRecord.topBorder || this.bottomBorder != xFRecord.bottomBorder) {
            return false;
        }
        if (this.leftBorderColour != xFRecord.leftBorderColour || this.rightBorderColour != xFRecord.rightBorderColour || this.topBorderColour != xFRecord.topBorderColour || this.bottomBorderColour != xFRecord.bottomBorderColour) {
            return false;
        }
        if (this.backgroundColour != xFRecord.backgroundColour || this.pattern != xFRecord.pattern) {
            return false;
        }
        return !(this.initialized && xFRecord.initialized ? this.fontIndex != xFRecord.fontIndex || this.formatIndex != xFRecord.formatIndex : !this.font.equals(xFRecord.font) || !this.format.equals(xFRecord.format));
    }

    final void setFormatIndex(int n) {
        this.formatIndex = n;
    }

    final int getFontIndex() {
        return this.fontIndex;
    }

    final void setFontIndex(int n) {
        this.fontIndex = n;
    }

    protected final void setXFDetails(XFRecord$XFType xFRecord$XFType, int n) {
        this.xfFormatType = xFRecord$XFType;
        this.parentFormat = n;
    }

    final void rationalize(IndexMapping indexMapping) {
        this.xfIndex = indexMapping.getNewIndex(this.xfIndex);
        if (this.xfFormatType == cell) {
            this.parentFormat = indexMapping.getNewIndex(this.parentFormat);
        }
    }

    public final void setFont(FontRecord fontRecord) {
        this.font = fontRecord;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

