/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.biff.CellReferenceHelper;

public class SheetRangeImpl
implements Range {
    private Sheet sheet;
    private int column1;
    private int row1;
    private int column2;
    private int row2;

    public SheetRangeImpl(Sheet sheet, int n, int n2, int n3, int n4) {
        this.sheet = sheet;
        this.row1 = n2;
        this.row2 = n4;
        this.column1 = n;
        this.column2 = n3;
    }

    public SheetRangeImpl(SheetRangeImpl sheetRangeImpl, Sheet sheet) {
        this.sheet = sheet;
        this.row1 = sheetRangeImpl.row1;
        this.row2 = sheetRangeImpl.row2;
        this.column1 = sheetRangeImpl.column1;
        this.column2 = sheetRangeImpl.column2;
    }

    public final Cell getTopLeft() {
        return this.sheet.getCell(this.column1, this.row1);
    }

    public final Cell getBottomRight() {
        return this.sheet.getCell(this.column2, this.row2);
    }

    public final int getFirstSheetIndex() {
        return -1;
    }

    public final int getLastSheetIndex() {
        return -1;
    }

    public final boolean intersects(SheetRangeImpl sheetRangeImpl) {
        if (sheetRangeImpl == this) {
            return true;
        }
        return this.row2 >= sheetRangeImpl.row1 && this.row1 <= sheetRangeImpl.row2 && this.column2 >= sheetRangeImpl.column1 && this.column1 <= sheetRangeImpl.column2;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        CellReferenceHelper.getCellReference(this.column1, this.row1, stringBuffer);
        stringBuffer.append('-');
        CellReferenceHelper.getCellReference(this.column2, this.row2, stringBuffer);
        return stringBuffer.toString();
    }

    public final void insertRow(int n) {
        if (n > this.row2) {
            return;
        }
        if (n <= this.row1) {
            ++this.row1;
        }
        if (n <= this.row2) {
            ++this.row2;
        }
    }

    public final void insertColumn(int n) {
        if (n > this.column2) {
            return;
        }
        if (n <= this.column1) {
            ++this.column1;
        }
        if (n <= this.column2) {
            ++this.column2;
        }
    }

    public final void removeRow(int n) {
        if (n > this.row2) {
            return;
        }
        if (n < this.row1) {
            --this.row1;
        }
        if (n < this.row2) {
            --this.row2;
        }
    }

    public final void removeColumn(int n) {
        if (n > this.column2) {
            return;
        }
        if (n < this.column1) {
            --this.column1;
        }
        if (n < this.column2) {
            --this.column2;
        }
    }

    public final int hashCode() {
        return 0xFFFF ^ this.row1 ^ this.row2 ^ this.column1 ^ this.column2;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SheetRangeImpl)) {
            return false;
        }
        SheetRangeImpl sheetRangeImpl = (SheetRangeImpl)object;
        return this.column1 == sheetRangeImpl.column1 && this.column2 == sheetRangeImpl.column2 && this.row1 == sheetRangeImpl.row1 && this.row2 == sheetRangeImpl.row2;
    }
}

