/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.read.biff.File;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableWorkbook;
import jxl.write.biff.WritableWorkbookImpl;

public abstract class Workbook {
    private static final String version = "2.5.8";

    protected Workbook() {
    }

    public abstract Sheet[] getSheets();

    public abstract String[] getSheetNames();

    public abstract Sheet getSheet(int var1);

    public abstract Sheet getSheet(String var1);

    public static final String getVersion() {
        return version;
    }

    public abstract int getNumberOfSheets();

    public abstract Cell findCellByName(String var1);

    public abstract Range[] findByName(String var1);

    public abstract String[] getRangeNames();

    public abstract boolean isProtected();

    protected abstract void parse();

    public abstract void close();

    public static final Workbook getWorkbook(java.io.File file) {
        return Workbook.getWorkbook(file, new WorkbookSettings());
    }

    public static final Workbook getWorkbook(java.io.File file, WorkbookSettings workbookSettings) {
        FileInputStream fileInputStream = new FileInputStream(file);
        File file2 = null;
        try {
            file2 = new File(fileInputStream, workbookSettings);
        }
        catch (IOException iOException) {
            fileInputStream.close();
            throw iOException;
        }
        catch (BiffException biffException) {
            fileInputStream.close();
            throw biffException;
        }
        fileInputStream.close();
        WorkbookParser workbookParser = new WorkbookParser(file2, workbookSettings);
        ((Workbook)workbookParser).parse();
        return workbookParser;
    }

    public static final Workbook getWorkbook(InputStream inputStream) {
        return Workbook.getWorkbook(inputStream, new WorkbookSettings());
    }

    public static final Workbook getWorkbook(InputStream inputStream, WorkbookSettings workbookSettings) {
        File file = new File(inputStream, workbookSettings);
        WorkbookParser workbookParser = new WorkbookParser(file, workbookSettings);
        ((Workbook)workbookParser).parse();
        return workbookParser;
    }

    public static final WritableWorkbook createWorkbook(java.io.File file) {
        return Workbook.createWorkbook(file, new WorkbookSettings());
    }

    public static final WritableWorkbook createWorkbook(java.io.File file, WorkbookSettings workbookSettings) {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(fileOutputStream, true, workbookSettings);
        return writableWorkbookImpl;
    }

    public static final WritableWorkbook createWorkbook(java.io.File file, Workbook workbook) {
        return Workbook.createWorkbook(file, workbook, new WorkbookSettings());
    }

    public static final WritableWorkbook createWorkbook(java.io.File file, Workbook workbook, WorkbookSettings workbookSettings) {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(fileOutputStream, workbook, true, workbookSettings);
        return writableWorkbookImpl;
    }

    public static final WritableWorkbook createWorkbook(OutputStream outputStream, Workbook workbook) {
        return Workbook.createWorkbook(outputStream, workbook, ((WorkbookParser)workbook).getSettings());
    }

    public static final WritableWorkbook createWorkbook(OutputStream outputStream, Workbook workbook, WorkbookSettings workbookSettings) {
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(outputStream, workbook, false, workbookSettings);
        return writableWorkbookImpl;
    }

    public static final WritableWorkbook createWorkbook(OutputStream outputStream) {
        return Workbook.createWorkbook(outputStream, new WorkbookSettings());
    }

    public static final WritableWorkbook createWorkbook(OutputStream outputStream, WorkbookSettings workbookSettings) {
        WritableWorkbookImpl writableWorkbookImpl = new WritableWorkbookImpl(outputStream, false, workbookSettings);
        return writableWorkbookImpl;
    }
}

