/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult$1;

public class TestResult {
    protected Vector fFailures = new Vector();
    protected Vector fErrors = new Vector();
    protected Vector fListeners = new Vector();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public final synchronized void addError(Test test, Throwable throwable) {
        this.fErrors.addElement(new TestFailure(test, throwable));
        Enumeration enumeration = this.cloneListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((TestListener)enumeration.nextElement()).addError(test, throwable);
        }
    }

    public final synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fFailures.addElement(new TestFailure(test, assertionFailedError));
        Enumeration enumeration = this.cloneListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((TestListener)enumeration.nextElement()).addFailure(test, assertionFailedError);
        }
    }

    public final synchronized void addListener(TestListener testListener) {
        this.fListeners.addElement(testListener);
    }

    public final synchronized void removeListener(TestListener testListener) {
        this.fListeners.removeElement(testListener);
    }

    private synchronized Vector cloneListeners() {
        return (Vector)this.fListeners.clone();
    }

    public final void endTest(Test test) {
        Enumeration enumeration = this.cloneListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((TestListener)enumeration.nextElement()).endTest(test);
        }
    }

    public final synchronized int errorCount() {
        return this.fErrors.size();
    }

    public final synchronized Enumeration errors() {
        return this.fErrors.elements();
    }

    public final synchronized int failureCount() {
        return this.fFailures.size();
    }

    public final synchronized Enumeration failures() {
        return this.fFailures.elements();
    }

    protected final void run(TestCase testCase) {
        this.startTest(testCase);
        TestResult$1 testResult$1 = new TestResult$1(testCase);
        this.runProtected(testCase, testResult$1);
        this.endTest(testCase);
    }

    public final synchronized int runCount() {
        return this.fRunTests;
    }

    public final void runProtected(Test test, Protectable protectable) {
        try {
            protectable.protect();
        }
        catch (AssertionFailedError assertionFailedError) {
            this.addFailure(test, assertionFailedError);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.addError(test, throwable);
        }
    }

    public final synchronized boolean shouldStop() {
        return this.fStop;
    }

    public final void startTest(Test test) {
        int n = test.countTestCases();
        Object object = this;
        synchronized (object) {
            this.fRunTests += n;
        }
        object = this.cloneListeners().elements();
        while (object.hasMoreElements()) {
            ((TestListener)object.nextElement()).startTest(test);
        }
    }

    public final synchronized void stop() {
        this.fStop = true;
    }

    public final synchronized boolean wasSuccessful() {
        return this.failureCount() == 0 && this.errorCount() == 0;
    }
}

